/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.wooden;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.tool.LogicCircuitHandler;
import blusunrize.immersiveengineering.api.utils.DirectionUtils;
import blusunrize.immersiveengineering.api.utils.ResettableLazy;
import blusunrize.immersiveengineering.api.wires.redstone.CapabilityRedstoneNetwork;
import blusunrize.immersiveengineering.common.blocks.BlockCapabilityRegistration;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlockEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.PlacementLimitation;
import blusunrize.immersiveengineering.common.items.LogicCircuitBoardItem;
import blusunrize.immersiveengineering.common.register.IEBlockEntities;
import blusunrize.immersiveengineering.common.register.IEDataComponents;
import blusunrize.immersiveengineering.common.register.IEMenuTypes;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;

public class LogicUnitBlockEntity
extends IEBaseBlockEntity
implements IIEInventory,
IEBlockInterfaces.IBlockEntityDrop,
IEBlockInterfaces.IInteractionObjectIE<LogicUnitBlockEntity>,
IEBlockInterfaces.IStateBasedDirectional,
LogicCircuitHandler.ILogicCircuitHandler {
    private static final int SIZE_COLORS = DyeColor.values().length;
    private static final int SIZE_REGISTERS = LogicCircuitHandler.LogicCircuitRegister.values().length - SIZE_COLORS;
    public static final int NUM_SLOTS = 10;
    private final NonNullList<ItemStack> inventory = NonNullList.withSize((int)10, (Object)ItemStack.EMPTY);
    private final Map<Direction, boolean[]> inputs = new EnumMap<Direction, boolean[]>(Direction.class);
    private final boolean[] registers = new boolean[SIZE_REGISTERS];
    private final boolean[] outputs = new boolean[SIZE_COLORS];
    private final Map<Direction, CapabilityRedstoneNetwork.RedstoneBundleConnection> redstoneCaps = new EnumMap<Direction, CapabilityRedstoneNetwork.RedstoneBundleConnection>(Direction.class);
    private final ResettableLazy<boolean[]> combinedInputs;

    public LogicUnitBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)IEBlockEntities.LOGIC_UNIT.get(), pos, state);
        for (Direction f : DirectionUtils.VALUES) {
            CapabilityRedstoneNetwork.RedstoneBundleConnection forSide = new CapabilityRedstoneNetwork.RedstoneBundleConnection(){

                @Override
                public void onChange(byte[] externalInputs, Direction side) {
                    boolean[] sideInputs = LogicUnitBlockEntity.this.inputs.getOrDefault(side, new boolean[SIZE_COLORS]);
                    boolean[] preInput = Arrays.copyOf(sideInputs, SIZE_COLORS);
                    for (int i = 0; i < SIZE_COLORS; ++i) {
                        sideInputs[i] = externalInputs[i] > 0;
                    }
                    if (!Arrays.equals(preInput, sideInputs)) {
                        LogicUnitBlockEntity.this.inputs.put(side, sideInputs);
                        LogicUnitBlockEntity.this.combinedInputs.reset();
                        LogicUnitBlockEntity.this.updateOutputs();
                    }
                }

                @Override
                public void updateInput(byte[] signals, Direction side) {
                    for (DyeColor dye : DyeColor.values()) {
                        if (!LogicUnitBlockEntity.this.outputs[dye.getId()]) continue;
                        signals[dye.getId()] = 15;
                    }
                }
            };
            this.redstoneCaps.put(f, forSide);
        }
        this.combinedInputs = new ResettableLazy<boolean[]>(() -> {
            boolean[] ret = new boolean[SIZE_COLORS];
            for (boolean[] side : this.inputs.values()) {
                for (int i = 0; i < SIZE_COLORS; ++i) {
                    int n = i;
                    ret[n] = ret[n] | side[i];
                }
            }
            return ret;
        });
    }

    @Override
    public Property<Direction> getFacingProperty() {
        return IEProperties.FACING_HORIZONTAL;
    }

    @Override
    public PlacementLimitation getFacingLimitation() {
        return PlacementLimitation.HORIZONTAL;
    }

    @Override
    public boolean mirrorFacingOnPlacement(LivingEntity placer) {
        return placer.isShiftKeyDown();
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket, HolderLookup.Provider provider) {
        ContainerHelper.loadAllItems((CompoundTag)nbt, this.inventory, (HolderLookup.Provider)provider);
        this.updateOutputs();
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket, HolderLookup.Provider provider) {
        ContainerHelper.saveAllItems((CompoundTag)nbt, this.inventory, (HolderLookup.Provider)provider);
    }

    @Override
    public void getBlockEntityDrop(LootContext context, Consumer<ItemStack> drop) {
        ItemStack stack = new ItemStack((ItemLike)this.getBlockState().getBlock(), 1);
        List<LogicCircuitHandler.LogicCircuitInstruction> instructions = this.getInstructions().toList();
        if (!instructions.isEmpty()) {
            stack.set(IEDataComponents.CIRCUIT_INSTRUCTIONS, instructions);
        }
        drop.accept(stack);
    }

    @Override
    public void onBEPlaced(BlockPlaceContext ctx) {
        List instructions = (List)ctx.getItemInHand().get(IEDataComponents.CIRCUIT_INSTRUCTIONS);
        if (instructions != null) {
            for (int i = 0; i < instructions.size(); ++i) {
                this.inventory.set(i, (Object)LogicCircuitBoardItem.buildCircuitBoard((LogicCircuitHandler.LogicCircuitInstruction)instructions.get(i)));
            }
        }
    }

    @Override
    public boolean canUseGui(Player player) {
        return true;
    }

    @Override
    public LogicUnitBlockEntity getGuiMaster() {
        return this;
    }

    @Override
    public IEMenuTypes.ArgContainer<LogicUnitBlockEntity, ?> getContainerType() {
        return IEMenuTypes.LOGIC_UNIT;
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        return stack.getItem() instanceof LogicCircuitBoardItem;
    }

    @Override
    public int getSlotLimit(int slot) {
        return 1;
    }

    @Override
    public void doGraphicalUpdates() {
        this.setChanged();
        this.updateOutputs();
        this.markContainingBlockForUpdate(null);
    }

    private void updateOutputs() {
        boolean[] outPre = Arrays.copyOf(this.outputs, SIZE_COLORS);
        Arrays.fill(this.registers, false);
        Arrays.fill(this.outputs, false);
        this.getInstructions().forEachOrdered(instruction -> instruction.apply(this));
        if (!Arrays.equals(outPre, this.outputs)) {
            this.markConnectorsDirty();
        }
    }

    private Stream<LogicCircuitHandler.LogicCircuitInstruction> getInstructions() {
        return this.inventory.stream().map(s -> (LogicCircuitHandler.LogicCircuitInstruction)s.get(IEDataComponents.CIRCUIT_INSTRUCTION)).filter(Objects::nonNull);
    }

    private void markConnectorsDirty() {
        this.redstoneCaps.values().forEach(CapabilityRedstoneNetwork.RedstoneBundleConnection::markDirty);
    }

    public static void registerCapabilities(BlockCapabilityRegistration.BECapabilityRegistrar<LogicUnitBlockEntity> registrar) {
        registrar.register(CapabilityRedstoneNetwork.REDSTONE_BUNDLE_CONNECTION, (be, side) -> side != null ? be.redstoneCaps.get(side) : null);
    }

    @Override
    public boolean getLogicCircuitRegister(LogicCircuitHandler.LogicCircuitRegister register) {
        if (register.ordinal() < SIZE_COLORS) {
            return this.combinedInputs.get()[register.ordinal()];
        }
        return this.registers[register.ordinal() - SIZE_COLORS];
    }

    @Override
    public void setLogicCircuitRegister(LogicCircuitHandler.LogicCircuitRegister register, boolean state) {
        if (register.ordinal() < SIZE_COLORS) {
            this.outputs[register.ordinal()] = state;
        } else {
            this.registers[register.ordinal() - LogicUnitBlockEntity.SIZE_COLORS] = state;
        }
    }
}

