/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.multiblocks.logic.arcfurnace;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

public class ArcFurnaceInputHandler
implements IItemHandler {
    private final IItemHandlerModifiable wrapped;
    private final Runnable onChanged;

    public ArcFurnaceInputHandler(IItemHandlerModifiable wrapped, Runnable onChanged) {
        this.wrapped = wrapped;
        this.onChanged = onChanged;
    }

    @NotNull
    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (stack.isEmpty()) {
            return stack;
        }
        stack = stack.copy();
        ArrayList<Integer> possibleSlots = new ArrayList<Integer>(12);
        for (int i = 0; i < 12; ++i) {
            ItemStack here = this.wrapped.getStackInSlot(i);
            if (here.isEmpty()) {
                if (!simulate) {
                    this.wrapped.setStackInSlot(i, stack);
                }
                this.onChanged.run();
                return ItemStack.EMPTY;
            }
            if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)here) || here.getCount() >= here.getMaxStackSize()) continue;
            possibleSlots.add(i);
        }
        possibleSlots.sort(Comparator.comparingInt(a -> this.wrapped.getStackInSlot(a.intValue()).getCount()));
        Iterator iterator = possibleSlots.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            ItemStack here = this.wrapped.getStackInSlot(i);
            int fillCount = Math.min(here.getMaxStackSize() - here.getCount(), stack.getCount());
            if (!simulate) {
                here.grow(fillCount);
            }
            stack.shrink(fillCount);
            if (!stack.isEmpty()) continue;
            this.onChanged.run();
            return ItemStack.EMPTY;
        }
        this.onChanged.run();
        return stack;
    }

    public int getSlots() {
        return 12;
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        return this.wrapped.getStackInSlot(slot);
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return ItemStack.EMPTY;
    }

    public int getSlotLimit(int slot) {
        return Math.min(64, this.wrapped.getSlotLimit(slot));
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return this.wrapped.isItemValid(slot, stack);
    }
}

