/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.utils.codec.IECodecs;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlockEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.PlacementLimitation;
import blusunrize.immersiveengineering.common.items.InternalStorageItem;
import blusunrize.immersiveengineering.common.register.IEBlockEntities;
import blusunrize.immersiveengineering.common.register.IEItems;
import blusunrize.immersiveengineering.common.register.IEMenuTypes;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;

public class ToolboxBlockEntity
extends IEBaseBlockEntity
implements IEBlockInterfaces.IStateBasedDirectional,
IEBlockInterfaces.IBlockBounds,
IIEInventory,
IEBlockInterfaces.IInteractionObjectIE<ToolboxBlockEntity>,
IEBlockInterfaces.IBlockEntityDrop,
IEBlockInterfaces.IPlayerInteraction {
    private final NonNullList<ItemStack> inventory = NonNullList.withSize((int)23, (Object)ItemStack.EMPTY);
    public Component name;
    private ItemEnchantments enchantments = ItemEnchantments.EMPTY;
    private static final VoxelShape boundsZ = Shapes.box((double)0.125, (double)0.0, (double)0.25, (double)0.875, (double)0.625, (double)0.75);
    private static final VoxelShape boundsX = Shapes.box((double)0.25, (double)0.0, (double)0.125, (double)0.75, (double)0.625, (double)0.875);

    public ToolboxBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)IEBlockEntities.TOOLBOX.get(), pos, state);
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket, HolderLookup.Provider provider) {
        if (nbt.contains("name", 8)) {
            this.name = Component.Serializer.fromJson((String)nbt.getString("name"), (HolderLookup.Provider)provider);
        }
        this.enchantments = (ItemEnchantments)IECodecs.fromNbtOrThrow(ItemEnchantments.CODEC, nbt.get("enchantments"));
        if (!descPacket) {
            ContainerHelper.loadAllItems((CompoundTag)nbt, this.inventory, (HolderLookup.Provider)provider);
        }
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket, HolderLookup.Provider provider) {
        if (this.name != null) {
            nbt.putString("name", Component.Serializer.toJson((Component)this.name, (HolderLookup.Provider)provider));
        }
        nbt.put("enchantments", IECodecs.toNbtOrThrow(ItemEnchantments.CODEC, this.enchantments));
        if (!descPacket) {
            ContainerHelper.saveAllItems((CompoundTag)nbt, this.inventory, (HolderLookup.Provider)provider);
        }
    }

    @Override
    public ItemInteractionResult interact(Direction side, Player player, InteractionHand hand, ItemStack heldItem, float hitX, float hitY, float hitZ) {
        if (player.isShiftKeyDown()) {
            if (!this.level.isClientSide) {
                ItemEntity entityitem = new ItemEntity(this.level, player.getX(), player.getY(), player.getZ(), this.getPickBlock(player, this.getBlockState(), (HitResult)new BlockHitResult(new Vec3((double)hitX, (double)hitY, (double)hitZ), side, this.worldPosition, false)), 0.0, 0.0, 0.0);
                this.level.removeBlock(this.getBlockPos(), false);
                this.level.addFreshEntity((Entity)entityitem);
            }
            return ItemInteractionResult.sidedSuccess((boolean)this.getLevelNonnull().isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Override
    public Component getDisplayName() {
        return this.name != null ? this.name : Component.translatable((String)"item.immersiveengineering.toolbox.name");
    }

    @Override
    public boolean canUseGui(Player player) {
        return true;
    }

    @Override
    public ToolboxBlockEntity getGuiMaster() {
        return this;
    }

    @Override
    public IEMenuTypes.ArgContainer<ToolboxBlockEntity, ?> getContainerType() {
        return IEMenuTypes.TOOLBOX_BLOCK;
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        return IEApi.isAllowedInCrate(stack);
    }

    @Override
    public int getSlotLimit(int slot) {
        return 64;
    }

    @Override
    public void doGraphicalUpdates() {
        this.setChanged();
    }

    @Override
    public void getBlockEntityDrop(LootContext context, Consumer<ItemStack> drop) {
        ItemStack stack = new ItemStack(IEItems.Tools.TOOLBOX);
        IEItems.Tools.TOOLBOX.get().setContainedItems(stack, this.inventory);
        if (this.name != null) {
            stack.set(DataComponents.CUSTOM_NAME, (Object)this.name);
        }
        if (this.enchantments != null) {
            stack.set(DataComponents.ENCHANTMENTS, (Object)this.enchantments);
        }
        drop.accept(stack);
    }

    @Override
    public void onBEPlaced(BlockPlaceContext ctx) {
        ItemStack stack = ctx.getItemInHand();
        if (stack.getItem() instanceof InternalStorageItem) {
            IItemHandler inv = (IItemHandler)stack.getCapability(Capabilities.ItemHandler.ITEM, null);
            if (inv != null) {
                for (int i = 0; i < inv.getSlots(); ++i) {
                    this.inventory.set(i, (Object)inv.getStackInSlot(i));
                }
                this.setChanged();
            }
            if (stack.has(DataComponents.CUSTOM_NAME)) {
                this.name = stack.getHoverName();
            }
            this.enchantments = (ItemEnchantments)stack.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
        }
    }

    @Override
    public Property<Direction> getFacingProperty() {
        return IEProperties.FACING_HORIZONTAL;
    }

    @Override
    public PlacementLimitation getFacingLimitation() {
        return PlacementLimitation.HORIZONTAL;
    }

    @Override
    public boolean mirrorFacingOnPlacement(LivingEntity placer) {
        return true;
    }

    @Override
    public boolean canHammerRotate(Direction side, Vec3 hit, LivingEntity entity) {
        return false;
    }

    @Override
    public VoxelShape getBlockBounds(@Nullable CollisionContext ctx) {
        return this.getFacing().getAxis() == Direction.Axis.Z ? boundsZ : boundsX;
    }
}

