/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render.tile;

import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MultiblockOrientation;
import blusunrize.immersiveengineering.client.render.tile.BERenderUtils;
import blusunrize.immersiveengineering.client.render.tile.DynamicModel;
import blusunrize.immersiveengineering.client.render.tile.IEMultiblockRenderer;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.SqueezerLogic;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.resources.model.BakedModel;
import net.neoforged.neoforge.client.model.data.ModelData;

public class SqueezerRenderer
extends IEMultiblockRenderer<SqueezerLogic.State> {
    public static final String NAME = "squeezer_piston";
    public static DynamicModel PISTON;

    @Override
    public void render(IMultiblockContext<SqueezerLogic.State> ctx, float partialTicks, PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        BlockRenderDispatcher blockRenderer = Minecraft.getInstance().getBlockRenderer();
        BakedModel model = PISTON.get();
        MultiblockOrientation orientation = ctx.getLevel().getOrientation();
        matrixStack.pushPose();
        matrixStack.translate(0.5, 0.5, 0.5);
        bufferIn = BERenderUtils.mirror(orientation, matrixStack, bufferIn);
        VertexConsumer buffer = bufferIn.getBuffer(RenderType.solid());
        float piston = ctx.getState().animation_piston;
        piston = piston * piston * (3.0f - 2.0f * piston);
        matrixStack.translate(0.0f, piston, 0.0f);
        matrixStack.translate(-0.5, -0.5, -0.5);
        SqueezerRenderer.rotateForFacing(matrixStack, orientation.front());
        blockRenderer.getModelRenderer().renderModel(matrixStack.last(), buffer, null, model, 1.0f, 1.0f, 1.0f, combinedLightIn, combinedOverlayIn, ModelData.EMPTY, RenderType.solid());
        matrixStack.popPose();
    }
}

