/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render.entity;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.utils.TransformingVertexBuilder;
import blusunrize.immersiveengineering.common.entities.ChemthrowerShotEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import org.joml.Quaternionf;

public class ChemthrowerShotRenderer
extends EntityRenderer<ChemthrowerShotEntity> {
    public ChemthrowerShotRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager);
    }

    public void render(ChemthrowerShotEntity entity, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        FluidStack f = entity.getFluid();
        if (f.isEmpty() && (f = entity.getFluidSynced()).isEmpty()) {
            return;
        }
        matrixStackIn.pushPose();
        matrixStackIn.mulPose(new Quaternionf().rotateXYZ(0.0f, (float)Math.toRadians(180.0f - this.entityRenderDispatcher.camera.getYRot()), 0.0f).rotateXYZ((float)Math.toRadians(-this.entityRenderDispatcher.camera.getXRot()), 0.0f, 0.0f));
        IClientFluidTypeExtensions props = IClientFluidTypeExtensions.of((Fluid)f.getFluid());
        TextureAtlasSprite sprite = ClientUtils.mc().getModelManager().getAtlas(InventoryMenu.BLOCK_ATLAS).getSprite(props.getStillTexture(f));
        int colour = props.getTintColor(f);
        float a = (float)(colour >> 24 & 0xFF) / 255.0f;
        float r = (float)(colour >> 16 & 0xFF) / 255.0f;
        float g = (float)(colour >> 8 & 0xFF) / 255.0f;
        float b = (float)(colour & 0xFF) / 255.0f;
        int lightAll = entity.getBrightnessForRender();
        int blockLight = Math.max(LightTexture.block((int)lightAll), LightTexture.block((int)packedLightIn));
        int skyLight = Math.max(LightTexture.sky((int)lightAll), LightTexture.sky((int)packedLightIn));
        packedLightIn = LightTexture.pack((int)blockLight, (int)skyLight);
        matrixStackIn.scale(0.25f, 0.25f, 0.25f);
        TransformingVertexBuilder builder = new TransformingVertexBuilder(bufferIn, RenderType.entityTranslucent((ResourceLocation)InventoryMenu.BLOCK_ATLAS), matrixStackIn);
        builder.defaultColor(r, g, b, a);
        builder.setDefaultNormal(0.0f, 1.0f, 0.0f);
        builder.setDefaultLight(packedLightIn);
        builder.setDefaultOverlay(OverlayTexture.NO_OVERLAY);
        builder.addVertex(-0.25f, -0.25f, 0.0f).setUv(sprite.getU(0.25f), sprite.getV(0.25f));
        builder.addVertex(0.25f, -0.25f, 0.0f).setUv(sprite.getU(0.0f), sprite.getV(0.25f));
        builder.addVertex(0.25f, 0.25f, 0.0f).setUv(sprite.getU(0.0f), sprite.getV(0.0f));
        builder.addVertex(-0.25f, 0.25f, 0.0f).setUv(sprite.getU(0.25f), sprite.getV(0.0f));
        matrixStackIn.popPose();
    }

    @Nonnull
    public ResourceLocation getTextureLocation(@Nonnull ChemthrowerShotEntity chemthrowerShotEntity) {
        return IEApi.ieLoc("textures/models/bullet.png");
    }
}

