/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.gui;

import blusunrize.immersiveengineering.client.gui.IEContainerScreen;
import blusunrize.immersiveengineering.common.gui.CrateEntityContainer;
import blusunrize.immersiveengineering.common.gui.CrateMenu;
import blusunrize.immersiveengineering.common.network.MessageContainerUpdate;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Inventory;
import net.neoforged.neoforge.network.PacketDistributor;

public abstract class CrateScreen<C extends CrateMenu>
extends IEContainerScreen<C> {
    private EditBox nameField;

    public CrateScreen(C container, Inventory inventoryPlayer, Component title) {
        super(container, inventoryPlayer, title, CrateScreen.makeTextureLocation("crate"));
        this.imageHeight = 168;
    }

    @Override
    protected void init() {
        super.init();
        this.nameField = new EditBox(this.font, this.leftPos + this.titleLabelX, this.topPos + this.titleLabelY, 162, 12, (Component)Component.translatable((String)"container.repair"));
        this.nameField.setTextColor(-557004);
        this.nameField.setBordered(false);
        this.nameField.setMaxLength(30);
        this.nameField.setResponder(s -> {
            if (!Objects.equals(s, this.title.getString())) {
                CompoundTag message = new CompoundTag();
                message.putString("name", s);
                PacketDistributor.sendToServer((CustomPacketPayload)new MessageContainerUpdate(((CrateMenu)this.getMenu()).containerId, message), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        });
        this.nameField.setValue(this.title.getString());
        this.addWidget((GuiEventListener)this.nameField);
    }

    @Override
    public void render(@Nonnull GuiGraphics graphics, int mx, int my, float partial) {
        super.render(graphics, mx, my, partial);
        this.nameField.render(graphics, mx, my, partial);
    }

    @Override
    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.drawString(this.font, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY, -557004, true);
    }

    public boolean keyPressed(int key, int scancode, int p_keyPressed_3_) {
        if (this.nameField.isFocused() && key != 256 && (this.nameField.keyPressed(key, scancode, p_keyPressed_3_) || this.nameField.canConsumeInput())) {
            return true;
        }
        return super.keyPressed(key, scancode, p_keyPressed_3_);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        boolean ret = super.mouseClicked(mouseX, mouseY, mouseButton);
        if (this.nameField.mouseClicked(mouseX, mouseY, mouseButton)) {
            this.nameField.setFocused(true);
            ret = true;
        } else if (this.nameField.isFocused()) {
            this.nameField.setFocused(false);
            ret = true;
        }
        return ret;
    }

    public static class EntityCrate
    extends CrateScreen<CrateEntityContainer> {
        public EntityCrate(CrateEntityContainer container, Inventory inventoryPlayer, Component title) {
            super(container, inventoryPlayer, title);
        }
    }

    public static class StandardCrate
    extends CrateScreen<CrateMenu> {
        public StandardCrate(CrateMenu container, Inventory inventoryPlayer, Component title) {
            super(container, inventoryPlayer, title);
        }
    }
}

