/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.gui;

import blusunrize.immersiveengineering.client.gui.IEContainerScreen;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.FurnaceHandler;
import blusunrize.immersiveengineering.common.gui.BlastFurnaceMenu;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;

public class BlastFurnaceScreen
extends IEContainerScreen<BlastFurnaceMenu> {
    private static final ResourceLocation TEXTURE = BlastFurnaceScreen.makeTextureLocation("blast_furnace");

    public BlastFurnaceScreen(BlastFurnaceMenu container, Inventory inventoryPlayer, Component title) {
        super(container, inventoryPlayer, title, TEXTURE);
    }

    public static void drawFlameAndArrow(ContainerData state, GuiGraphics graphics, int leftPos, int topPos, int arrowXOffset) {
        if (FurnaceHandler.StateView.getLastBurnTime(state) > 0) {
            int h = (int)(12.0f * ((float)FurnaceHandler.StateView.getBurnTime(state) / (float)FurnaceHandler.StateView.getLastBurnTime(state)));
            graphics.blit(TEXTURE, leftPos + 56, topPos + 37 + 12 - h, 179, 13 - h, 9, h);
        }
        if (FurnaceHandler.StateView.getMaxProcess(state) > 0) {
            int w = (int)(22.0f * (1.0f - (float)FurnaceHandler.StateView.getProcess(state) / (float)FurnaceHandler.StateView.getMaxProcess(state)));
            graphics.blit(TEXTURE, leftPos + arrowXOffset, topPos + 35, 177, 14, w, 16);
        }
    }

    @Override
    protected void drawBackgroundTexture(GuiGraphics graphics) {
        graphics.blit(TEXTURE, this.leftPos, this.topPos, 0, 0, 176, this.imageHeight);
    }

    @Override
    protected void drawContainerBackgroundPre(@Nonnull GuiGraphics graphics, float f, int mx, int my) {
        BlastFurnaceScreen.drawFlameAndArrow(((BlastFurnaceMenu)this.menu).state, graphics, this.leftPos, this.topPos, 76);
    }

    public static class Advanced
    extends BlastFurnaceScreen {
        public Advanced(BlastFurnaceMenu container, Inventory inventoryPlayer, Component title) {
            super(container, inventoryPlayer, title);
            this.imageWidth = 210;
        }

        @Override
        protected void drawContainerBackgroundPre(@Nonnull GuiGraphics graphics, float f, int mx, int my) {
            graphics.blit(TEXTURE, this.leftPos + 140, this.topPos + 11, 176, 32, 70, 46);
            if (((BlastFurnaceMenu)this.menu).leftHeater.get().booleanValue()) {
                graphics.blit(TEXTURE, this.leftPos + 182, this.topPos + 27, 200, 22, 10, 10);
            }
            if (((BlastFurnaceMenu)this.menu).rightHeater.get().booleanValue()) {
                graphics.blit(TEXTURE, this.leftPos + 182, this.topPos + 39, 200, 22, 10, 10);
            }
            super.drawContainerBackgroundPre(graphics, f, mx, my);
        }

        @Override
        protected void renderLabels(GuiGraphics graphics, int x, int y) {
            String title = I18n.get((String)"gui.immersiveengineering.blast_furnace.preheaters", (Object[])new Object[0]);
            int w = this.font.width(title) / 2;
            graphics.drawString(this.font, title, 175 - w, 18, 0xAEAEAE);
            graphics.drawString(this.font, I18n.get((String)"gui.immersiveengineering.left", (Object[])new Object[0]), 154, 28, 0xAEAEAE);
            graphics.drawString(this.font, I18n.get((String)"gui.immersiveengineering.right", (Object[])new Object[0]), 154, 40, 0xAEAEAE);
        }
    }
}

