/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.multiblocks;

import blusunrize.immersiveengineering.api.multiblocks.ClientMultiblocks;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.ICancellableEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

public class MultiblockHandler {
    static List<IMultiblock> multiblocks = new ArrayList<IMultiblock>();
    static Map<ResourceLocation, IMultiblock> byUniqueName = new HashMap<ResourceLocation, IMultiblock>();

    public static synchronized void registerMultiblock(IMultiblock multiblock) {
        multiblocks.add(multiblock);
        byUniqueName.put(multiblock.getUniqueName(), multiblock);
    }

    public static List<IMultiblock> getMultiblocks() {
        return multiblocks;
    }

    @Nullable
    public static IMultiblock getByUniqueName(ResourceLocation name) {
        return byUniqueName.get(name);
    }

    public static MultiblockFormEvent postMultiblockFormationEvent(Player player, IMultiblock multiblock, BlockPos clickedBlock, ItemStack hammer) {
        MultiblockFormEvent event = new MultiblockFormEvent(player, multiblock, clickedBlock, hammer);
        NeoForge.EVENT_BUS.post((Event)event);
        return event;
    }

    public static interface IMultiblock {
        public ResourceLocation getUniqueName();

        public boolean isBlockTrigger(BlockState var1, Direction var2, @Nonnull Level var3);

        public boolean createStructure(Level var1, BlockPos var2, Direction var3, Player var4);

        public List<StructureTemplate.StructureBlockInfo> getStructure(@Nonnull Level var1);

        public float getManualScale();

        public Vec3i getSize(@Nonnull Level var1);

        public void disassemble(Level var1, BlockPos var2, boolean var3, Direction var4);

        public BlockPos getTriggerOffset();

        public void initializeClient(Consumer<ClientMultiblocks.MultiblockManualData> var1);

        public Component getDisplayName();

        default public Block getBlock() {
            return Blocks.AIR;
        }
    }

    public static class MultiblockFormEvent
    extends PlayerEvent
    implements ICancellableEvent {
        private final IMultiblock multiblock;
        private final BlockPos clickedBlock;
        private final ItemStack hammer;

        public MultiblockFormEvent(Player player, IMultiblock multiblock, BlockPos clickedBlock, ItemStack hammer) {
            super(player);
            this.multiblock = multiblock;
            this.clickedBlock = clickedBlock;
            this.hammer = hammer;
        }

        public IMultiblock getMultiblock() {
            return this.multiblock;
        }

        public BlockPos getClickedBlock() {
            return this.clickedBlock;
        }

        public ItemStack getHammer() {
            return this.hammer;
        }
    }
}

