/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api;

import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.context.UseOnContext;

public class TargetingInfo {
    public final Direction side;
    public final float hitX;
    public final float hitY;
    public final float hitZ;

    public TargetingInfo(UseOnContext ctx) {
        this(ctx.getClickedFace(), (float)ctx.getClickLocation().x, (float)ctx.getClickLocation().y, (float)ctx.getClickLocation().z);
    }

    public TargetingInfo(Direction side, float hitX, float hitY, float hitZ) {
        this.side = side;
        this.hitX = hitX;
        this.hitY = hitY;
        this.hitZ = hitZ;
    }

    public void writeToNBT(CompoundTag tag) {
        tag.putInt("side", this.side.ordinal());
        tag.putFloat("hitX", this.hitX);
        tag.putFloat("hitY", this.hitY);
        tag.putFloat("hitZ", this.hitZ);
    }

    public static TargetingInfo readFromNBT(CompoundTag tag) {
        return new TargetingInfo(Direction.from3DDataValue((int)tag.getInt("side")), tag.getFloat("hitX"), tag.getFloat("hitY"), tag.getFloat("hitZ"));
    }
}

