/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez.utils;

import com.mojang.blaze3d.systems.RenderSystem;
import de.maxhenkel.pipez.corelib.client.RenderUtils;
import de.maxhenkel.pipez.corelib.helpers.AbstractStack;
import de.maxhenkel.pipez.corelib.helpers.WrappedFluidStack;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class WrappedGasStack
extends AbstractStack<ChemicalStack> {
    public WrappedGasStack(ChemicalStack stack) {
        super(stack);
    }

    @Nullable
    public static WrappedGasStack dummyStack(Object o) {
        if (o instanceof Chemical) {
            Chemical chemical = (Chemical)o;
            return new WrappedGasStack(new ChemicalStack(chemical, 1000L));
        }
        return null;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(GuiGraphics guiGraphics, int x, int y) {
        TextureAtlasSprite texture = Minecraft.getInstance().getModelManager().getAtlas(InventoryMenu.BLOCK_ATLAS).getSprite(((ChemicalStack)this.stack).getChemical().getIcon());
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        int chemicalTint = ((ChemicalStack)this.stack).getChemicalTint();
        RenderSystem.setShaderColor((float)RenderUtils.getRedFloat(chemicalTint), (float)RenderUtils.getGreenFloat(chemicalTint), (float)RenderUtils.getBlueFloat(chemicalTint), (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture.atlasLocation());
        WrappedFluidStack.fluidBlit(guiGraphics, x, y, 16, 16, texture, ((ChemicalStack)this.stack).getChemical().getTint());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<Component> getTooltip() {
        ResourceLocation registryName;
        ArrayList<Component> tooltip = new ArrayList<Component>();
        tooltip.add(this.getDisplayName());
        if (Minecraft.getInstance().options.advancedItemTooltips && (registryName = MekanismAPI.CHEMICAL_REGISTRY.getKey((Object)((ChemicalStack)this.stack).getChemical())) != null) {
            tooltip.add((Component)Component.literal((String)registryName.toString()).withStyle(ChatFormatting.DARK_GRAY));
        }
        return tooltip;
    }

    @Override
    public Component getDisplayName() {
        return Component.empty().append(((ChemicalStack)this.stack).getTextComponent());
    }

    @Override
    public boolean isEmpty() {
        return ((ChemicalStack)this.stack).isEmpty();
    }
}

