/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez.codec;

import com.mojang.serialization.Codec;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;

public class EnumIndexCodec {
    public static <T extends Enum<T>> Codec<T> of(Class<T> enumClass) {
        Enum[] enumConstants = (Enum[])enumClass.getEnumConstants();
        return Codec.BYTE.xmap(b -> enumConstants[b], t -> (byte)t.ordinal());
    }

    public static <T extends Enum<T>> StreamCodec<RegistryFriendlyByteBuf, T> ofStream(Class<T> enumClass) {
        final Enum[] enumConstants = (Enum[])enumClass.getEnumConstants();
        return new StreamCodec<RegistryFriendlyByteBuf, T>(){

            public T decode(RegistryFriendlyByteBuf buf) {
                return enumConstants[buf.readByte()];
            }

            public void encode(RegistryFriendlyByteBuf buf, T value) {
                buf.writeByte(((Enum)value).ordinal());
            }
        };
    }
}

