/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez.blocks.tileentity.configuration;

import de.maxhenkel.pipez.blocks.tileentity.types.PipeType;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;

public abstract class CachedPipeConfiguration<T> {
    private final Map<PipeType<?, ?>, T>[] cachedValues;
    protected Supplier<NonNullList<ItemStack>> upgradeInventory;
    protected Function<PipeType<?, ?>, T> defaultValue;
    protected Runnable onDirty;

    public CachedPipeConfiguration(Supplier<NonNullList<ItemStack>> upgradeInventory, Function<PipeType<?, ?>, T> defaultValue, Runnable onDirty) {
        this.upgradeInventory = upgradeInventory;
        this.defaultValue = defaultValue;
        this.onDirty = onDirty;
        this.cachedValues = new HashMap[Direction.values().length];
    }

    public T getValue(Direction side, PipeType<?, ?> pipeType) {
        Map<PipeType<?, ?>, T> map = this.cachedValues[side.ordinal()];
        if (map == null) {
            map = new HashMap();
            this.cachedValues[side.ordinal()] = map;
        }
        if (map.containsKey(pipeType)) {
            return map.get(pipeType);
        }
        ItemStack stack = (ItemStack)this.upgradeInventory.get().get(side.ordinal());
        T value = this.get(pipeType, stack);
        if (stack.isEmpty() || value == null) {
            return this.putDefault(pipeType, map);
        }
        map.put(pipeType, value);
        return value;
    }

    public T putDefault(PipeType<?, ?> pipeType, Map<PipeType<?, ?>, T> map) {
        T def = this.defaultValue.apply(pipeType);
        map.put(pipeType, def);
        return def;
    }

    public void setValue(Direction side, PipeType<?, ?> pipeType, T value) {
        ItemStack stack;
        Map<PipeType<?, ?>, T> map = this.cachedValues[side.ordinal()];
        if (map == null) {
            map = new HashMap();
            this.cachedValues[side.ordinal()] = map;
        }
        if ((stack = (ItemStack)this.upgradeInventory.get().get(side.ordinal())).isEmpty()) {
            return;
        }
        map.put(pipeType, value);
        this.set(pipeType, stack, value);
        this.onDirty.run();
    }

    public void invalidate() {
        for (Map<PipeType<?, ?>, T> map : this.cachedValues) {
            if (map == null) continue;
            map.clear();
        }
    }

    public abstract T get(PipeType<?, ?> var1, ItemStack var2);

    public abstract void set(PipeType<?, ?> var1, ItemStack var2, T var3);
}

