/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.module;

import mods.railcraft.util.fluids.FluidTools;
import mods.railcraft.world.level.block.entity.tank.TankBlockEntity;
import mods.railcraft.world.level.material.StandardTank;
import mods.railcraft.world.module.ContainerModule;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;

public class TankModule
extends ContainerModule<TankBlockEntity> {
    public static final int SLOT_INPUT = 0;
    public static final int SLOT_PROCESS = 1;
    public static final int SLOT_OUTPUT = 2;
    private final StandardTank tank;
    private final IItemHandler itemHandler = new InvWrapper(this, this){

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot == 2) {
                return ItemStack.EMPTY;
            }
            return super.extractItem(slot, amount, simulate);
        }
    };
    private FluidTools.ProcessState processState = FluidTools.ProcessState.RESET;
    private int processTicks;

    public TankModule(TankBlockEntity provider, StandardTank tank) {
        super(provider, 3);
        this.tank = tank;
    }

    public StandardTank getTank() {
        return this.tank;
    }

    @Override
    public void serverTick() {
        if (this.processTicks++ >= 8) {
            this.processTicks = 0;
            this.processState = FluidTools.processContainer(this, this.tank, FluidTools.ProcessType.DRAIN_THEN_FILL, this.processState);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean canPlaceItem(int slot, ItemStack stack) {
        switch (slot) {
            case 0: {
                if (!this.tank.isEmpty() && FluidTools.isRoomInContainer(stack, this.tank.getFluid().getFluid())) break;
                if (!FluidUtil.getFluidContained((ItemStack)stack).isPresent()) return false;
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            default: {
                return false;
            }
        }
        if (!super.canPlaceItem(slot, stack)) return false;
        return true;
    }

    public IItemHandler getItemHandler() {
        return this.itemHandler;
    }

    @Override
    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag tag = super.serializeNBT(provider);
        tag.put("tank", (Tag)this.tank.writeToNBT(provider, new CompoundTag()));
        tag.putString("processState", this.processState.getSerializedName());
        return tag;
    }

    @Override
    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag tag) {
        super.deserializeNBT(provider, tag);
        this.tank.readFromNBT(provider, tag.getCompound("tank"));
        this.processState = FluidTools.ProcessState.fromTag(tag);
    }

    @Override
    public void writeToBuf(RegistryFriendlyByteBuf out) {
        super.writeToBuf(out);
        out.writeVarInt(this.tank.getCapacity());
        FluidStack.OPTIONAL_STREAM_CODEC.encode((Object)out, (Object)this.tank.getFluid());
    }

    @Override
    public void readFromBuf(RegistryFriendlyByteBuf in) {
        super.readFromBuf(in);
        this.tank.setCapacity(in.readVarInt());
        this.tank.setFluid((FluidStack)FluidStack.OPTIONAL_STREAM_CODEC.decode((Object)in));
    }
}

