/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.module;

import java.util.concurrent.atomic.AtomicReference;
import mods.railcraft.RailcraftConfig;
import mods.railcraft.api.charge.Charge;
import mods.railcraft.api.charge.ChargeStorage;
import mods.railcraft.tags.RailcraftTags;
import mods.railcraft.util.container.AdvancedContainer;
import mods.railcraft.world.item.RailcraftItems;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntity;
import mods.railcraft.world.level.block.entity.SteamTurbineBlockEntity;
import mods.railcraft.world.level.material.StandardTank;
import mods.railcraft.world.module.ChargeModule;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.IFluidTank;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class SteamTurbineModule
extends ChargeModule<SteamTurbineBlockEntity> {
    private static final int ROTOR_DAMAGE_CHANCE = 200;
    public static final int CHARGE_OUTPUT = 225;
    private static final int STEAM_USAGE = 360;
    public static final int TANK_STEAM = 0;
    public static final int TANK_WATER = 1;
    private final StandardTank steamTank;
    private final StandardTank waterTank;
    private final AdvancedContainer rotorContainer = new AdvancedContainer(1);
    private float operatingRatio;
    private int energy;
    private final IFluidHandler fluidHandler = new FluidHandler();

    public SteamTurbineModule(SteamTurbineBlockEntity provider, Charge network) {
        super(provider, network);
        this.rotorContainer.listener((RailcraftBlockEntity)this.provider);
        this.steamTank = StandardTank.ofBuckets(4).filter(RailcraftTags.Fluids.STEAM).disableDrain().changeCallback(() -> ((SteamTurbineBlockEntity)provider).setChanged());
        this.waterTank = StandardTank.ofBuckets(4).filter((TagKey<Fluid>)FluidTags.WATER).disableFill().changeCallback(() -> ((SteamTurbineBlockEntity)provider).setChanged());
    }

    public IFluidHandler getFluidHandler() {
        return this.fluidHandler;
    }

    @Override
    public void serverTick() {
        ItemStack rotorStack;
        FluidStack steam;
        super.serverTick();
        boolean addedEnergy = false;
        if (this.energy < 225 * ((Double)RailcraftConfig.SERVER.turbinePowerMultiplier.get()).intValue() && (steam = this.steamTank.internalDrain(360, IFluidHandler.FluidAction.SIMULATE)).getAmount() >= 360 && (rotorStack = this.rotorContainer.getItem(0)).is((Item)RailcraftItems.TURBINE_ROTOR.get())) {
            addedEnergy = true;
            this.energy += 225 * ((Double)RailcraftConfig.SERVER.turbinePowerMultiplier.get()).intValue();
            this.steamTank.internalDrain(360, IFluidHandler.FluidAction.EXECUTE);
            this.waterTank.internalFill(new FluidStack((Fluid)Fluids.WATER, 2), IFluidHandler.FluidAction.EXECUTE);
            this.rotorContainer.setItem(0, SteamTurbineModule.useRotor((ServerLevel)((SteamTurbineBlockEntity)this.provider).level(), rotorStack));
        }
        boolean thisTick = addedEnergy;
        this.operatingRatio = ((float)thisTick - this.operatingRatio) * 0.05f + this.operatingRatio;
        ChargeStorage chargeStorage = this.storage().get();
        if (!chargeStorage.isFull()) {
            chargeStorage.receiveEnergy(this.energy, false);
            this.energy = 0;
        }
    }

    public float getOperatingRatio() {
        return this.operatingRatio;
    }

    public Container getRotorContainer() {
        return this.rotorContainer;
    }

    public boolean needsMaintenance() {
        ItemStack rotorStack = this.rotorContainer.getItem(0);
        return rotorStack.isEmpty() || !rotorStack.is((Item)RailcraftItems.TURBINE_ROTOR.get()) || (float)rotorStack.getDamageValue() / (float)rotorStack.getMaxDamage() > 0.75f;
    }

    @Override
    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag tag = super.serializeNBT(provider);
        tag.put("steamTank", (Tag)this.steamTank.writeToNBT(provider, new CompoundTag()));
        tag.put("waterTank", (Tag)this.waterTank.writeToNBT(provider, new CompoundTag()));
        tag.put("rotorContainer", (Tag)this.rotorContainer.createTag(provider));
        tag.putInt("energy", this.energy);
        tag.putFloat("operatingRatio", this.operatingRatio);
        return tag;
    }

    @Override
    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag tag) {
        super.deserializeNBT(provider, tag);
        this.steamTank.readFromNBT(provider, tag.getCompound("steamTank"));
        this.waterTank.readFromNBT(provider, tag.getCompound("waterTank"));
        this.rotorContainer.fromTag(tag.getList("rotorContainer", 10), provider);
        this.energy = tag.getInt("energy");
        this.operatingRatio = tag.getFloat("operatingRatio");
    }

    private static ItemStack useRotor(ServerLevel level, ItemStack stack) {
        RandomSource random = level.getRandom();
        if (random.nextInt(200) == 0) {
            AtomicReference<ItemStack> result = new AtomicReference<ItemStack>(stack);
            stack.hurtAndBreak(1, level, null, item -> result.set(ItemStack.EMPTY));
            return result.get();
        }
        return stack;
    }

    public class FluidHandler
    implements IFluidHandler {
        public int getTanks() {
            return 2;
        }

        private IFluidTank getTank(int tank) {
            return tank == 0 ? SteamTurbineModule.this.steamTank : SteamTurbineModule.this.waterTank;
        }

        public FluidStack getFluidInTank(int tank) {
            return this.getTank(tank).getFluid();
        }

        public int getTankCapacity(int tank) {
            return this.getTank(tank).getCapacity();
        }

        public boolean isFluidValid(int tank, FluidStack stack) {
            return this.getTank(tank).isFluidValid(stack);
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return SteamTurbineModule.this.steamTank.fill(resource, action);
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            return SteamTurbineModule.this.waterTank.drain(resource, action);
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return SteamTurbineModule.this.waterTank.drain(maxDrain, action);
        }
    }
}

