/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.material;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import mods.railcraft.world.level.material.StandardTank;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class TankManager
implements IFluidHandler,
INBTSerializable<ListTag> {
    public static final TankManager EMPTY = new TankManager(List.of());
    public static final BiFunction<BlockEntity, Direction, Boolean> TANK_FILTER = (be, dir) -> be.getLevel().getCapability(Capabilities.FluidHandler.BLOCK, be.getBlockPos(), dir) != null;
    private final List<StandardTank> tanks;

    public TankManager(StandardTank ... tanks) {
        this(new ArrayList<StandardTank>(Arrays.asList(tanks)));
    }

    private TankManager(List<StandardTank> tanks) {
        this.tanks = tanks;
    }

    public boolean add(StandardTank tank) {
        return this.tanks.add(tank);
    }

    public ListTag serializeNBT(HolderLookup.Provider provider) {
        ListTag tanksTag = new ListTag();
        for (byte i = 0; i < this.tanks.size(); i = (byte)(i + 1)) {
            StandardTank tank = this.tanks.get(i);
            CompoundTag tankTag = new CompoundTag();
            tankTag.putByte("index", i);
            tank.writeToNBT(provider, tankTag);
            tanksTag.add((Object)tankTag);
        }
        return tanksTag;
    }

    public void deserializeNBT(HolderLookup.Provider provider, ListTag tanksTag) {
        for (int i = 0; i < tanksTag.size(); ++i) {
            CompoundTag tag = tanksTag.getCompound(i);
            byte index = tag.getByte("index");
            if (index < 0 || index >= this.tanks.size()) continue;
            this.tanks.get(index).readFromNBT(provider, tag);
        }
    }

    public void writePacketData(RegistryFriendlyByteBuf data) {
        for (StandardTank tank : this.tanks) {
            FluidStack.OPTIONAL_STREAM_CODEC.encode((Object)data, (Object)tank.getFluid());
        }
    }

    public void readPacketData(RegistryFriendlyByteBuf data) {
        for (StandardTank tank : this.tanks) {
            tank.setFluid((FluidStack)FluidStack.OPTIONAL_STREAM_CODEC.decode((Object)data));
        }
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction doFill) {
        return this.tanks.stream().mapToInt(tank -> tank.fill(resource, doFill)).filter(filled -> filled > 0).findFirst().orElse(0);
    }

    public int fill(int tankIndex, FluidStack resource, IFluidHandler.FluidAction doFill) {
        return this.tanks.get(tankIndex).fill(resource, doFill);
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction doDrain) {
        return this.tanks.stream().map(tank -> tank.drain(resource, doDrain)).filter(fluid -> !fluid.isEmpty()).findFirst().orElse(FluidStack.EMPTY);
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction doDrain) {
        return this.tanks.stream().map(tank -> tank.drain(maxDrain, doDrain)).filter(fluid -> !fluid.isEmpty()).findFirst().orElse(FluidStack.EMPTY);
    }

    public FluidStack drain(int tankIndex, FluidStack resource, IFluidHandler.FluidAction doDrain) {
        return this.tanks.get(tankIndex).drain(resource, doDrain);
    }

    public FluidStack drain(int tankIndex, int maxDrain, IFluidHandler.FluidAction doDrain) {
        return this.tanks.get(tankIndex).drain(maxDrain, doDrain);
    }

    public StandardTank get(int tankIndex) {
        return this.tanks.get(tankIndex);
    }

    public void setCapacity(int tankIndex, int capacity) {
        StandardTank tank = this.get(tankIndex);
        tank.setCapacity(capacity);
        FluidStack fluidStack = tank.getFluid();
        if (fluidStack.getAmount() > capacity) {
            fluidStack.setAmount(capacity);
        }
    }

    public void pull(Collection<IFluidHandler> targets, int tankIndex, int amount) {
        this.transfer(targets, tankIndex, (me, them) -> FluidUtil.tryFluidTransfer((IFluidHandler)me, (IFluidHandler)them, (int)amount, (boolean)true));
    }

    public void push(Collection<IFluidHandler> targets, int tankIndex, int amount) {
        this.transfer(targets, tankIndex, (me, them) -> FluidUtil.tryFluidTransfer((IFluidHandler)them, (IFluidHandler)me, (int)amount, (boolean)true));
    }

    public void transfer(Collection<IFluidHandler> targets, int tankIndex, BiConsumer<IFluidHandler, IFluidHandler> transfer) {
        targets.forEach(them -> transfer.accept((IFluidHandler)this.get(tankIndex), (IFluidHandler)them));
    }

    public int getTanks() {
        return this.tanks.size();
    }

    public FluidStack getFluidInTank(int tank) {
        return this.tanks.get(tank).getFluid();
    }

    public int getTankCapacity(int tank) {
        return this.tanks.get(tank).getCapacity();
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return this.tanks.get(tank).isFluidValid(stack);
    }
}

