/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.signal;

import java.util.EnumMap;
import java.util.Map;
import mods.railcraft.util.VoxelShapeUtil;
import mods.railcraft.world.level.block.post.PostBlock;
import mods.railcraft.world.level.block.signal.SignalBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class SingleSignalBlock
extends SignalBlock {
    public static final BooleanProperty DOWN = BlockStateProperties.DOWN;
    public static final VoxelShape SHAPE = SingleSignalBlock.box((double)3.0, (double)6.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    public static final VoxelShape POST_SHAPE = SingleSignalBlock.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0);

    public SingleSignalBlock(BlockBehaviour.Properties properties) {
        super(SHAPE, SingleSignalBlock.createConnectionShapes(), properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    private static Map<Direction, VoxelShape> createConnectionShapes() {
        EnumMap<Direction, VoxelShape> connectionShapes = new EnumMap<Direction, VoxelShape>(Direction.class);
        connectionShapes.putAll(PostBlock.HORIZONTAL_CONNECTION_SHAPES);
        connectionShapes.put(Direction.DOWN, POST_SHAPE);
        return connectionShapes;
    }

    @Override
    protected int computeShapeIndex(BlockState blockState) {
        int i = super.computeShapeIndex(blockState);
        if (((Boolean)blockState.getValue((Property)DOWN)).booleanValue()) {
            i |= VoxelShapeUtil.indexFor(Direction.DOWN);
        }
        return i;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{DOWN});
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Direction facing = context.getHorizontalDirection().getOpposite();
        BlockPos downPos = pos.below();
        BlockState downState = level.getBlockState(downPos);
        return (BlockState)super.getStateForPlacement(context).setValue((Property)DOWN, (Comparable)Boolean.valueOf(this.connectsTo(downState, downState.isFaceSturdy((BlockGetter)level, downPos, Direction.UP), Direction.DOWN, facing)));
    }

    @Override
    public BlockState updateShape(BlockState state, Direction direction, BlockState newState, LevelAccessor world, BlockPos pos, BlockPos newPos) {
        state = super.updateShape(state, direction, newState, world, pos, newPos);
        return direction == Direction.DOWN ? (BlockState)state.setValue((Property)DOWN, (Comparable)Boolean.valueOf(this.connectsTo(newState, newState.isFaceSturdy((BlockGetter)world, newPos, direction.getOpposite()), direction, (Direction)state.getValue((Property)FACING)))) : state;
    }
}

