/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.signal;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Map;
import mods.railcraft.tags.RailcraftTags;
import mods.railcraft.util.LevelUtil;
import mods.railcraft.util.VoxelShapeUtil;
import mods.railcraft.world.level.block.entity.signal.AbstractSignalBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class SignalBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty NORTH = PipeBlock.NORTH;
    public static final BooleanProperty EAST = PipeBlock.EAST;
    public static final BooleanProperty SOUTH = PipeBlock.SOUTH;
    public static final BooleanProperty WEST = PipeBlock.WEST;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final Map<Direction, BooleanProperty> propertyByDirection = Map.of(Direction.NORTH, NORTH, Direction.EAST, EAST, Direction.SOUTH, SOUTH, Direction.WEST, WEST);
    private final VoxelShape[] shapes;
    protected final Object2IntMap<BlockState> stateToIndex = new Object2IntOpenHashMap();

    protected SignalBlock(VoxelShape shape, Map<Direction, VoxelShape> connectionShapes, BlockBehaviour.Properties properties) {
        super(properties);
        this.shapes = VoxelShapeUtil.makeShapes(shape, connectionShapes);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{NORTH, EAST, WEST, SOUTH, FACING, WATERLOGGED});
    }

    public RenderShape getRenderShape(BlockState blockState) {
        return RenderShape.MODEL;
    }

    public VoxelShape getShape(BlockState blockState, BlockGetter level, BlockPos blockPos, CollisionContext context) {
        return this.shapes[this.getShapeIndex(blockState)];
    }

    public final int getShapeIndex(BlockState blockState) {
        return this.stateToIndex.computeIfAbsent((Object)blockState, this::computeShapeIndex);
    }

    protected int computeShapeIndex(BlockState blockState) {
        int i = 0;
        for (Map.Entry<Direction, BooleanProperty> entry : propertyByDirection.entrySet()) {
            if (!((Boolean)blockState.getValue((Property)entry.getValue())).booleanValue()) continue;
            i |= VoxelShapeUtil.indexFor(entry.getKey());
        }
        return i;
    }

    public boolean propagatesSkylightDown(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return (Boolean)blockState.getValue((Property)WATERLOGGED) == false;
    }

    public int getLightBlock(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return LevelUtil.getBlockEntity(blockGetter, blockPos, AbstractSignalBlockEntity.class).map(AbstractSignalBlockEntity::getLightValue).orElseGet(() -> super.getLightBlock(blockState, blockGetter, blockPos));
    }

    public BlockState rotate(BlockState blockState, Rotation rotation) {
        return (BlockState)blockState.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)blockState.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        FluidState fluidState = level.getFluidState(pos);
        Direction facing = context.getHorizontalDirection().getOpposite();
        BlockPos northPos = pos.north();
        BlockPos southPos = pos.south();
        BlockPos westPos = pos.west();
        BlockPos eastPos = pos.east();
        BlockState northState = level.getBlockState(northPos);
        BlockState southState = level.getBlockState(southPos);
        BlockState westState = level.getBlockState(westPos);
        BlockState eastState = level.getBlockState(eastPos);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)NORTH, (Comparable)Boolean.valueOf(this.connectsTo(northState, northState.isFaceSturdy((BlockGetter)level, northPos, Direction.SOUTH), Direction.NORTH, facing)))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(this.connectsTo(southState, southState.isFaceSturdy((BlockGetter)level, southPos, Direction.NORTH), Direction.SOUTH, facing)))).setValue((Property)WEST, (Comparable)Boolean.valueOf(this.connectsTo(westState, westState.isFaceSturdy((BlockGetter)level, westPos, Direction.EAST), Direction.WEST, facing)))).setValue((Property)EAST, (Comparable)Boolean.valueOf(this.connectsTo(eastState, eastState.isFaceSturdy((BlockGetter)level, eastPos, Direction.WEST), Direction.EAST, facing)))).setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState newState, LevelAccessor world, BlockPos pos, BlockPos newPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            world.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        return direction.getAxis().isHorizontal() ? (BlockState)state.setValue((Property)propertyByDirection.get(direction), (Comparable)Boolean.valueOf(this.connectsTo(newState, newState.isFaceSturdy((BlockGetter)world, newPos, direction.getOpposite()), direction, (Direction)state.getValue((Property)FACING)))) : state;
    }

    public boolean connectsTo(BlockState blockState, boolean faceStudry, Direction direction, Direction facing) {
        if (facing == direction) {
            return false;
        }
        if (blockState.is(RailcraftTags.Blocks.SIGNAL)) {
            return SignalBlock.connectsToDirection(blockState, direction);
        }
        if (blockState.is(RailcraftTags.Blocks.POST)) {
            return true;
        }
        if (SignalBlock.isExceptionForConnection((BlockState)blockState) || !faceStudry) {
            return false;
        }
        if (blockState.is(BlockTags.FENCES) || blockState.is(BlockTags.WALLS)) {
            return direction.getAxis().getPlane() != Direction.Plane.HORIZONTAL;
        }
        return true;
    }

    public static boolean connectsToDirection(BlockState blockState, Direction direction) {
        return direction.getAxis().isVertical() || direction.getOpposite() != blockState.getValue((Property)FACING);
    }
}

