/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity;

import it.unimi.dsi.fastutil.chars.CharList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import mods.railcraft.RailcraftConfig;
import mods.railcraft.Translations;
import mods.railcraft.api.charge.Charge;
import mods.railcraft.api.charge.ChargeStorage;
import mods.railcraft.util.EnergyUtil;
import mods.railcraft.util.fluids.FluidTools;
import mods.railcraft.world.inventory.SteamTurbineMenu;
import mods.railcraft.world.level.block.RailcraftBlocks;
import mods.railcraft.world.level.block.SteamTurbineBlock;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import mods.railcraft.world.level.block.entity.multiblock.BlockPredicate;
import mods.railcraft.world.level.block.entity.multiblock.MultiblockBlockEntity;
import mods.railcraft.world.level.block.entity.multiblock.MultiblockPattern;
import mods.railcraft.world.module.ChargeModule;
import mods.railcraft.world.module.SteamTurbineModule;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

public class SteamTurbineBlockEntity
extends MultiblockBlockEntity<SteamTurbineBlockEntity, Void> {
    private static final int WATER_OUTPUT_RATE = 4;
    private static final int ENERGY_OUTPUT_RATE = 900;
    private static final BlockPredicate BLOCK_PREDICATE = BlockPredicate.of(RailcraftBlocks.STEAM_TURBINE);
    private static final MultiblockPattern<Void> pattern = MultiblockPattern.builder((Vec3i)BlockPos.ZERO).layer(List.of(CharList.of((char)'A', (char)'W', (char)'B'), CharList.of((char)'B', (char)'W', (char)'A'))).layer(List.of(CharList.of((char)'C', (char)'X', (char)'D'), CharList.of((char)'D', (char)'X', (char)'C'))).predicate('A', BLOCK_PREDICATE).predicate('B', BLOCK_PREDICATE).predicate('C', BLOCK_PREDICATE).predicate('D', BLOCK_PREDICATE).predicate('X', BLOCK_PREDICATE).predicate('W', BLOCK_PREDICATE).build();
    private static final MultiblockPattern<Void> rotatedPattern = pattern.rotateClockwise();
    private static final List<MultiblockPattern<Void>> patterns = List.of(pattern, rotatedPattern);
    private final SteamTurbineModule module;
    private float lastGaugeValue;
    private float masterOperatingRatio;
    private int syncTicks;

    public SteamTurbineBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RailcraftBlockEntityTypes.STEAM_TURBINE.get(), blockPos, blockState, SteamTurbineBlockEntity.class, patterns);
        this.module = this.moduleDispatcher.registerModule("steam_turbine", new SteamTurbineModule(this, Charge.distribution));
    }

    public SteamTurbineModule getSteamTurbineModule() {
        return this.module;
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, SteamTurbineBlockEntity blockEntity) {
        blockEntity.serverTick();
        blockEntity.moduleDispatcher.serverTick();
        blockEntity.masterOperatingRatio = 0.0f;
        blockEntity.getMasterBlockEntity().map(SteamTurbineBlockEntity::getSteamTurbineModule).ifPresent(master -> {
            blockEntity.masterOperatingRatio = master.getOperatingRatio();
            Predicate<BlockEntity> filter = other -> {
                SteamTurbineBlockEntity tank;
                return !(other instanceof SteamTurbineBlockEntity) || !(tank = (SteamTurbineBlockEntity)other).getMembership().equals(blockEntity.getMembership());
            };
            EnergyUtil.pushToSides(level, blockPos, master.getEnergyStorage(), 900 * ((Double)RailcraftConfig.SERVER.turbineEnergyOutputRateMultiplier.get()).intValue(), filter, Direction.values());
            Collection<IFluidHandler> neighbors = FluidTools.findNeighbors(level, blockPos, filter, Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST);
            for (IFluidHandler neighbor : neighbors) {
                FluidUtil.tryFluidTransfer((IFluidHandler)neighbor, (IFluidHandler)master.getFluidHandler(), (int)4, (boolean)true);
            }
        });
        if (blockEntity.syncTicks++ >= 4) {
            blockEntity.syncTicks = 0;
            blockEntity.syncToClient();
        }
    }

    public float getAndSmoothGaugeValue() {
        this.lastGaugeValue = (this.lastGaugeValue * 14.0f + this.masterOperatingRatio) / 15.0f;
        return this.lastGaugeValue;
    }

    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        return new SteamTurbineMenu(id, inventory, this);
    }

    @Override
    public Component getDisplayName() {
        return Component.translatable((String)Translations.Container.STEAM_TURBINE);
    }

    @Override
    public void writeToBuf(RegistryFriendlyByteBuf out) {
        super.writeToBuf(out);
        out.writeFloat(this.masterOperatingRatio);
    }

    @Override
    public void readFromBuf(RegistryFriendlyByteBuf in) {
        super.readFromBuf(in);
        this.masterOperatingRatio = in.readFloat();
    }

    @Nullable
    public IFluidHandler getFluidCap(@Nullable Direction side) {
        Optional<SteamTurbineModule> masterModule = this.getMasterBlockEntity().map(SteamTurbineBlockEntity::getSteamTurbineModule);
        return masterModule.map(SteamTurbineModule::getFluidHandler).orElse(null);
    }

    @Nullable
    public IEnergyStorage getEnergyCap(@Nullable Direction side) {
        Optional<SteamTurbineModule> masterModule = this.getMasterBlockEntity().map(SteamTurbineBlockEntity::getSteamTurbineModule);
        return masterModule.map(ChargeModule::getEnergyStorage).orElse(null);
    }

    @Override
    protected boolean isBlockEntity(MultiblockPattern.Element element) {
        return true;
    }

    @Override
    protected void membershipChanged(@Nullable MultiblockBlockEntity.Membership<SteamTurbineBlockEntity> membership) {
        if (membership == null) {
            this.module.storage().ifPresent(storage -> storage.setState(ChargeStorage.State.DISABLED));
            this.level.setBlockAndUpdate(this.getBlockPos(), (BlockState)this.getBlockState().setValue(SteamTurbineBlock.TYPE, (Comparable)((Object)SteamTurbineBlock.Type.NONE)));
            Containers.dropContents((Level)this.level, (BlockPos)this.getBlockPos(), (Container)this.module.getRotorContainer());
            return;
        }
        if (membership.master() == this) {
            this.module.storage().ifPresent(storage -> storage.setState(ChargeStorage.State.SOURCE));
        }
        SteamTurbineBlock.Type type = switch (membership.patternElement().marker()) {
            case 'A' -> SteamTurbineBlock.Type.TOP_LEFT;
            case 'B' -> SteamTurbineBlock.Type.TOP_RIGHT;
            case 'C' -> SteamTurbineBlock.Type.BOTTOM_LEFT;
            case 'D' -> SteamTurbineBlock.Type.BOTTOM_RIGHT;
            case 'W' -> SteamTurbineBlock.Type.WINDOW;
            case 'X' -> SteamTurbineBlock.Type.NONE;
            default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf(membership.patternElement()));
        };
        this.level.setBlockAndUpdate(this.getBlockPos(), (BlockState)((BlockState)this.getBlockState().setValue(SteamTurbineBlock.TYPE, (Comparable)((Object)type))).setValue(SteamTurbineBlock.ROTATED, (Comparable)Boolean.valueOf(membership.master().getCurrentPattern().get() == rotatedPattern)));
    }
}

