/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity;

import com.mojang.authlib.GameProfile;
import mods.railcraft.api.core.Lockable;
import mods.railcraft.api.util.EnumUtil;
import mods.railcraft.client.gui.widget.button.ButtonTexture;
import mods.railcraft.client.gui.widget.button.TexturePosition;
import mods.railcraft.gui.button.ButtonState;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class LockableSwitchTrackActuatorBlockEntity
extends RailcraftBlockEntity
implements Lockable {
    private Lock lock = Lock.UNLOCKED;

    public LockableSwitchTrackActuatorBlockEntity(BlockEntityType<?> type, BlockPos blockPos, BlockState blockState) {
        super(type, blockPos, blockState);
    }

    public Lock getLock() {
        return this.lock;
    }

    public void setLock(@Nullable GameProfile gameProfile) {
        this.lock = gameProfile == null ? Lock.UNLOCKED : Lock.LOCKED;
        this.setOwner(gameProfile);
    }

    @Override
    public boolean isLocked() {
        return this.lock == Lock.LOCKED;
    }

    @Override
    public boolean canAccess(GameProfile gameProfile) {
        return !this.isLocked() || this.isOwnerOrOperator(gameProfile);
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putString("lock", this.lock.getSerializedName());
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.lock = Lock.fromName(tag.getString("lock"));
    }

    @Override
    public void writeToBuf(RegistryFriendlyByteBuf data) {
        super.writeToBuf(data);
        data.writeEnum((Enum)this.lock);
    }

    @Override
    public void readFromBuf(RegistryFriendlyByteBuf data) {
        super.readFromBuf(data);
        this.lock = (Lock)data.readEnum(Lock.class);
    }

    public static enum Lock implements ButtonState<Lock>,
    StringRepresentable
    {
        UNLOCKED("unlocked", ButtonTexture.UNLOCKED_BUTTON),
        LOCKED("locked", ButtonTexture.LOCKED_BUTTON);

        private static final StringRepresentable.EnumCodec<Lock> CODEC;
        private final String name;
        private final TexturePosition texture;

        private Lock(String name, TexturePosition texture) {
            this.name = name;
            this.texture = texture;
        }

        @Override
        public Component label() {
            return Component.empty();
        }

        @Override
        public TexturePosition texturePosition() {
            return this.texture;
        }

        @Override
        public Lock next() {
            return (Lock)EnumUtil.next((Enum)this, (Enum[])Lock.values());
        }

        public String getSerializedName() {
            return this.name;
        }

        public static Lock fromName(String name) {
            return (Lock)CODEC.byName(name, (Enum)UNLOCKED);
        }

        static {
            CODEC = StringRepresentable.fromEnum(Lock::values);
        }
    }
}

