/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import mods.railcraft.Translations;
import mods.railcraft.integrations.jei.JeiSearchable;
import mods.railcraft.world.level.block.entity.FeedStationBlockEntity;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class FeedStationBlock
extends BaseEntityBlock
implements JeiSearchable {
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    private static final MapCodec<FeedStationBlock> CODEC = FeedStationBlock.simpleCodec(FeedStationBlock::new);

    protected FeedStationBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{POWERED});
    }

    public RenderShape getRenderShape(BlockState blockState) {
        return RenderShape.MODEL;
    }

    protected InteractionResult useWithoutItem(BlockState blockState, Level level, BlockPos pos, Player player, BlockHitResult rayTraceResult) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            level.getBlockEntity(pos, (BlockEntityType)RailcraftBlockEntityTypes.FEED_STATION.get()).ifPresent(blockEntity -> serverPlayer.openMenu((MenuProvider)blockEntity, pos));
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide());
    }

    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new FeedStationBlockEntity(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> type) {
        return level.isClientSide() ? null : FeedStationBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)RailcraftBlockEntityTypes.FEED_STATION.get()), FeedStationBlockEntity::serverTick);
    }

    public void neighborChanged(BlockState blockState, Level level, BlockPos blockPos, Block neighborBlock, BlockPos neighborPos, boolean moved) {
        if (!level.isClientSide()) {
            Boolean powered = (Boolean)blockState.getValue((Property)POWERED);
            boolean neighborSignal = level.hasNeighborSignal(blockPos);
            if (powered != neighborSignal) {
                level.setBlock(blockPos, (BlockState)blockState.setValue((Property)POWERED, (Comparable)Boolean.valueOf(neighborSignal)), 2);
            }
        }
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity;
        if (!state.is(newState.getBlock()) && (blockEntity = level.getBlockEntity(pos)) instanceof FeedStationBlockEntity) {
            FeedStationBlockEntity feedStation = (FeedStationBlockEntity)blockEntity;
            Containers.dropContents((Level)level, (BlockPos)pos, (Container)feedStation);
            level.updateNeighbourForOutputSignal(pos, (Block)this);
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltip, flag);
        tooltip.add((Component)Component.translatable((String)Translations.Tips.FEED_STATION).withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.translatable((String)Translations.Tips.APPLY_REDSTONE_TO_DISABLE).withStyle(ChatFormatting.RED));
    }

    @Override
    public Component jeiDescription() {
        return Component.translatable((String)Translations.Jei.FEED_STATION);
    }
}

