/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.item;

import java.util.List;
import mods.railcraft.Translations;
import mods.railcraft.season.Season;
import mods.railcraft.world.item.CrowbarItem;
import mods.railcraft.world.item.component.RailcraftDataComponents;
import mods.railcraft.world.item.component.SeasonComponent;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class SeasonsCrowbarItem
extends CrowbarItem {
    public SeasonsCrowbarItem(Tiers tiers, Item.Properties properties) {
        super((Tier)tiers, properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (!level.isClientSide()) {
            SeasonsCrowbarItem.incrementSeason(itemStack);
            Season season = SeasonsCrowbarItem.getSeason(itemStack);
            player.displayClientMessage(SeasonsCrowbarItem.getDescriptionText(season, false), true);
        }
        return InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)level.isClientSide());
    }

    public boolean isValidRepairItem(ItemStack itemToRepair, ItemStack stack) {
        return false;
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> list, TooltipFlag adv) {
        Season season = SeasonsCrowbarItem.getSeason(stack);
        list.add(SeasonsCrowbarItem.getDescriptionText(season, true));
    }

    public static Season getSeason(ItemStack itemStack) {
        if (itemStack.has(RailcraftDataComponents.SEASON)) {
            return ((SeasonComponent)itemStack.get(RailcraftDataComponents.SEASON)).season();
        }
        return Season.DEFAULT;
    }

    private static void incrementSeason(ItemStack itemStack) {
        Season season = SeasonsCrowbarItem.getSeason(itemStack).getNext();
        itemStack.set(RailcraftDataComponents.SEASON, (Object)new SeasonComponent(season));
    }

    private static Component getDescriptionText(Season value, boolean tooltip) {
        MutableComponent title = Component.translatable((String)Translations.Tips.CROWBAR_SEASON_DESC);
        if (tooltip) {
            title.withStyle(ChatFormatting.GRAY);
        }
        return title.append(CommonComponents.SPACE).append((Component)value.getDisplayName().copy().withStyle(ChatFormatting.DARK_PURPLE));
    }
}

