/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.entity.vehicle;

import com.mojang.authlib.GameProfile;
import com.mojang.logging.LogUtils;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import mods.railcraft.api.carts.Linkable;
import mods.railcraft.api.carts.RollingStock;
import mods.railcraft.api.carts.Side;
import mods.railcraft.api.carts.Train;
import mods.railcraft.api.event.CartLinkEvent;
import mods.railcraft.world.entity.vehicle.LaunchState;
import mods.railcraft.world.entity.vehicle.MinecartUtil;
import mods.railcraft.world.entity.vehicle.TrainImpl;
import mods.railcraft.world.entity.vehicle.locomotive.Locomotive;
import mods.railcraft.world.level.block.track.behaivor.HighSpeedTrackUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2d;
import org.joml.Vector2dc;
import org.slf4j.Logger;

public class RollingStockImpl
implements RollingStock,
INBTSerializable<CompoundTag> {
    private static final double LINK_DRAG = 0.95;
    private static final float MAX_DISTANCE = 8.0f;
    private static final float STIFFNESS = 0.7f;
    private static final float HS_STIFFNESS = 0.7f;
    private static final float DAMPING = 0.4f;
    private static final float HS_DAMPING = 0.3f;
    private static final float FORCE_LIMITER = 6.0f;
    private static final int DIMENSION_TIMEOUT_TICKS = 200;
    private static final Logger LOGGER = LogUtils.getLogger();
    private final AbstractMinecart minecart;
    @Nullable
    private TrainImpl train;
    @Nullable
    private RollingStock frontLink;
    @Nullable
    private RollingStock backLink;
    @Nullable
    private UUID unresolvedBackLink;
    @Nullable
    private UUID unresolvedFrontLink;
    private boolean backAutoLinkEnabled;
    private boolean frontAutoLinkEnabled;
    private LaunchState launchState = LaunchState.LANDED;
    private int elevatorRemainingTicks;
    private int preventMountRemainingTicks;
    private int derailedRemainingTicks;
    private boolean explosionPending;
    private boolean highSpeed;
    private int primaryLinkTimeoutTicks;
    private int secondaryLinkTimeoutTicks;

    public RollingStockImpl(IAttachmentHolder holder) {
        if (!(holder instanceof AbstractMinecart)) {
            throw new IllegalArgumentException("holder must be instance of AbstractMinecart.");
        }
        AbstractMinecart minecart = (AbstractMinecart)holder;
        this.minecart = minecart;
    }

    @Override
    public boolean hasLink(Side side) {
        return switch (side) {
            default -> throw new MatchException(null, null);
            case Side.FRONT -> {
                if (this.frontLink != null) {
                    yield true;
                }
                yield false;
            }
            case Side.BACK -> this.backLink != null;
        };
    }

    @Override
    public Optional<RollingStock> linkAt(Side side) {
        this.resolveLinks();
        return Optional.ofNullable(switch (side) {
            default -> throw new MatchException(null, null);
            case Side.FRONT -> this.frontLink;
            case Side.BACK -> this.backLink;
        });
    }

    private void setLink(Side side, @Nullable RollingStock minecart) {
        switch (side) {
            case FRONT: {
                this.frontLink = minecart;
                break;
            }
            case BACK: {
                this.backLink = minecart;
            }
        }
    }

    private void resolveLinks() {
        if (this.unresolvedBackLink != null) {
            this.resolveLink(this.unresolvedBackLink).ifPresent(cart -> {
                this.backLink = cart;
                this.unresolvedBackLink = null;
            });
        }
        if (this.unresolvedFrontLink != null) {
            this.resolveLink(this.unresolvedFrontLink).ifPresent(cart -> {
                this.frontLink = cart;
                this.unresolvedFrontLink = null;
            });
        }
    }

    private Optional<RollingStock> resolveLink(UUID minecartId) {
        Optional<RollingStock> optional;
        ServerLevel level = (ServerLevel)this.minecart.level();
        Entity entity = level.getEntity(minecartId);
        if (entity instanceof AbstractMinecart) {
            AbstractMinecart minecart = (AbstractMinecart)entity;
            optional = Optional.ofNullable((RollingStock)minecart.getCapability(CAPABILITY)).filter(cart -> {
                boolean result = cart.isLinkedWith(this);
                if (!result) {
                    LOGGER.warn("Link mismatch between {} and {} (link was missing on {})", new Object[]{this.minecart, cart.entity(), cart.entity()});
                }
                return result;
            });
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    @Override
    public Optional<Side> sideOf(RollingStock rollingStock) {
        Objects.requireNonNull(rollingStock, "rollingStock cannot be null.");
        if (this.unresolvedBackLink != null && rollingStock.entity().getUUID().equals(this.unresolvedBackLink)) {
            this.unresolvedBackLink = null;
            this.backLink = rollingStock;
            return Optional.of(Side.BACK);
        }
        if (this.unresolvedFrontLink != null && rollingStock.entity().getUUID().equals(this.unresolvedFrontLink)) {
            this.unresolvedFrontLink = null;
            this.frontLink = rollingStock;
            return Optional.of(Side.FRONT);
        }
        if (this.backLink == rollingStock) {
            return Optional.of(Side.BACK);
        }
        if (this.frontLink == rollingStock) {
            return Optional.of(Side.FRONT);
        }
        return Optional.empty();
    }

    @Override
    public boolean link(RollingStock rollingStock) {
        float maxDistance = this.getLinkageDistanceSq(rollingStock);
        if (this == rollingStock || this.isSameTrainAs(rollingStock) || !this.isEnd() || !rollingStock.isEnd() || this.entity().distanceToSqr((Entity)rollingStock.entity()) > (double)maxDistance) {
            return false;
        }
        if (!this.isLinkableWith(rollingStock) || !rollingStock.isLinkableWith(this)) {
            return false;
        }
        Train train = this.train();
        rollingStock.train().copyTo(train);
        Side linkSide = null;
        for (Side side : Side.values()) {
            if (this.disabledSide().filter(side::equals).isPresent()) continue;
            if (rollingStock.disabledSide().map(Side::opposite).filter(side::equals).isPresent()) continue;
            if (!this.hasLink(side) && !rollingStock.hasLink(side.opposite())) {
                linkSide = side;
                break;
            }
            if (!this.hasLink(side.opposite()) && !rollingStock.hasLink(side.opposite()) && this.swapLinks(side)) {
                linkSide = side;
                break;
            }
            if (this.hasLink(side) || rollingStock.hasLink(side) || !rollingStock.swapLinks(side.opposite())) continue;
            linkSide = side;
            break;
        }
        if (linkSide == null) {
            return false;
        }
        this.completeLink(rollingStock, linkSide);
        rollingStock.completeLink(this, linkSide.opposite());
        train.copyTo(this.train());
        NeoForge.EVENT_BUS.post((Event)new CartLinkEvent.Link(this, rollingStock));
        return true;
    }

    @Override
    public void completeLink(RollingStock rollingStock, Side side) {
        this.setLink(side, rollingStock);
        this.setAutoLinkEnabled(side, false);
        AbstractMinecart abstractMinecart = this.minecart;
        if (abstractMinecart instanceof Linkable) {
            Linkable handler = (Linkable)abstractMinecart;
            handler.linked(rollingStock);
        }
    }

    @Override
    public void removeLink(Side side) {
        this.linkAt(side).ifPresent(linked -> {
            this.setLink(side, null);
            AbstractMinecart patt0$temp = this.minecart;
            if (patt0$temp instanceof Linkable) {
                Linkable handler = (Linkable)patt0$temp;
                handler.unlinked((RollingStock)linked);
            }
        });
    }

    @Override
    public boolean unlink(Side side) {
        RollingStock linkedCart = this.linkAt(side).orElse(null);
        if (linkedCart == null) {
            return false;
        }
        linkedCart.sideOf(this).ifPresent(linkedCart::removeLink);
        this.removeLink(side);
        NeoForge.EVENT_BUS.post((Event)new CartLinkEvent.Unlink(this, linkedCart));
        return true;
    }

    @Override
    public boolean swapLinks(Side side) {
        RollingStock next;
        switch (side) {
            default: {
                throw new MatchException(null, null);
            }
            case FRONT: {
                RollingStock rollingStock = this.frontLink;
                break;
            }
            case BACK: {
                RollingStock rollingStock = next = this.backLink;
            }
        }
        if (next != null && !next.swapLinks(side)) {
            return false;
        }
        if (this.disabledSide().isPresent()) {
            return false;
        }
        RollingStock oldFront = this.frontLink;
        this.frontLink = this.backLink;
        this.backLink = oldFront;
        return true;
    }

    @Override
    public boolean isAutoLinkEnabled(Side side) {
        return switch (side) {
            default -> throw new MatchException(null, null);
            case Side.BACK -> this.backAutoLinkEnabled;
            case Side.FRONT -> this.frontAutoLinkEnabled;
        };
    }

    @Override
    public boolean setAutoLinkEnabled(Side side, boolean enabled) {
        if (enabled) {
            if (this.disabledSide().filter(side::equals).isPresent()) {
                return false;
            }
        }
        switch (side) {
            case BACK: {
                this.backAutoLinkEnabled = enabled;
                break;
            }
            case FRONT: {
                this.frontAutoLinkEnabled = enabled;
            }
        }
        return true;
    }

    @Override
    public boolean isLaunched() {
        return this.launchState == LaunchState.LAUNCHED;
    }

    @Override
    public void launch() {
        this.launchState = LaunchState.LAUNCHING;
        this.minecart.setCanUseRail(false);
    }

    @Override
    public int getElevatorRemainingTicks() {
        return this.elevatorRemainingTicks;
    }

    @Override
    public void setElevatorRemainingTicks(int elevatorRemainingTicks) {
        this.elevatorRemainingTicks = elevatorRemainingTicks;
    }

    @Override
    public boolean isMountable() {
        return this.preventMountRemainingTicks <= 0;
    }

    @Override
    public void setPreventMountRemainingTicks(int preventMountRemainingTicks) {
        this.preventMountRemainingTicks = preventMountRemainingTicks;
    }

    @Override
    public boolean isDerailed() {
        return this.derailedRemainingTicks > 0;
    }

    @Override
    public void setDerailedRemainingTicks(int derailedRemainingTicks) {
        this.derailedRemainingTicks = derailedRemainingTicks;
    }

    @Override
    public void primeExplosion() {
        this.explosionPending = true;
    }

    @Override
    public boolean isHighSpeed() {
        return this.highSpeed;
    }

    @Override
    public void checkHighSpeed(BlockPos blockPos) {
        Vec3 currentMotion = this.minecart.getDeltaMovement();
        if (this.highSpeed) {
            HighSpeedTrackUtil.checkSafetyAndExplode(this.level(), blockPos, this.minecart);
            return;
        }
        if (!HighSpeedTrackUtil.isTrackSafeForHighSpeed(this.level(), blockPos, this.minecart)) {
            this.limitSpeed();
            return;
        }
        if (Math.abs(currentMotion.x()) > (double)0.499f) {
            double motionX = Math.copySign((double)0.499f, currentMotion.x());
            this.minecart.setDeltaMovement(motionX, currentMotion.y(), currentMotion.z());
            this.highSpeed = true;
        }
        if (Math.abs(currentMotion.z()) > (double)0.499f) {
            double motionZ = Math.copySign((double)0.499f, currentMotion.z());
            this.minecart.setDeltaMovement(currentMotion.x(), currentMotion.y(), motionZ);
            this.highSpeed = true;
        }
    }

    private void limitSpeed() {
        Vec3 motion = this.minecart.getDeltaMovement();
        double motionX = Math.copySign(Math.min((double)0.499f, Math.abs(motion.x())), motion.x());
        double motionZ = Math.copySign(Math.min((double)0.499f, Math.abs(motion.z())), motion.z());
        this.minecart.setDeltaMovement(motionX, motion.y(), motionZ);
    }

    @Override
    public AbstractMinecart entity() {
        return this.minecart;
    }

    @Override
    public boolean isFront() {
        this.resolveLinks();
        return this.frontLink == null;
    }

    private boolean validateTrainOwnership() {
        boolean front = this.isFront();
        if (!front && this.train != null) {
            this.train = null;
        }
        if (front && this.train == null) {
            this.train = TrainImpl.create(this);
        }
        return front;
    }

    @Override
    public Train train() {
        return this.validateTrainOwnership() ? this.train : this.frontLink.train();
    }

    @Override
    public void removed(Entity.RemovalReason reason) {
        if (reason.shouldDestroy()) {
            this.unlinkAll();
        }
    }

    @Override
    public void tick() {
        int cutoff;
        float distance;
        if (this.level().isClientSide()) {
            return;
        }
        this.adjustCart();
        if (this.preventMountRemainingTicks > 0) {
            --this.preventMountRemainingTicks;
        }
        if (this.elevatorRemainingTicks < 20) {
            this.minecart.setNoGravity(false);
        }
        if (this.elevatorRemainingTicks > 0) {
            --this.elevatorRemainingTicks;
        }
        if (this.derailedRemainingTicks > 0) {
            --this.derailedRemainingTicks;
        }
        if (this.explosionPending) {
            this.explosionPending = false;
            MinecartUtil.explodeCart(this.entity());
        }
        if (this.highSpeed) {
            if (MinecartUtil.cartVelocityIsLessThan(this.entity(), 0.5f)) {
                this.highSpeed = false;
            } else if (this.launchState == LaunchState.LANDED) {
                HighSpeedTrackUtil.checkSafetyAndExplode(this.level(), this.minecart.blockPosition(), this.entity());
            }
        }
        if ((distance = Mth.degreesDifference((float)this.minecart.getYRot(), (float)this.minecart.yRotO)) < (float)(-(cutoff = 120)) || distance >= (float)cutoff) {
            this.minecart.setYRot(this.minecart.getYRot() + 180.0f);
            this.minecart.flipped = !this.minecart.flipped;
            this.minecart.setYRot(this.minecart.getYRot() % 360.0f);
        }
        if (BaseRailBlock.isRail((Level)this.level(), (BlockPos)this.minecart.blockPosition())) {
            this.minecart.fallDistance = 0.0f;
            if (this.minecart.isVehicle()) {
                this.minecart.getPassengers().forEach(p -> {
                    p.fallDistance = 0.0f;
                });
            }
            if (this.launchState == LaunchState.LAUNCHED) {
                this.land();
            }
        } else if (this.launchState == LaunchState.LAUNCHING) {
            this.launchState = LaunchState.LAUNCHED;
            this.minecart.setCanUseRail(true);
        } else if (this.launchState == LaunchState.LAUNCHED && this.minecart.onGround()) {
            this.land();
        }
        Vec3 motion = this.minecart.getDeltaMovement();
        double motionX = Math.copySign(Math.min(Math.abs(motion.x()), 9.5), motion.x());
        double motionY = Math.copySign(Math.min(Math.abs(motion.y()), 9.5), motion.y());
        double motionZ = Math.copySign(Math.min(Math.abs(motion.z()), 9.5), motion.z());
        this.minecart.setDeltaMovement(motionX, motionY, motionZ);
    }

    private void adjustCart() {
        boolean linked;
        if (this.isLaunched() || this.isOnElevator()) {
            return;
        }
        boolean linkedA = this.maintainLink(Side.BACK);
        boolean linkedB = this.maintainLink(Side.FRONT);
        boolean bl = linked = linkedA || linkedB;
        if (linked && !this.isHighSpeed()) {
            this.minecart.setDeltaMovement(this.minecart.getDeltaMovement().multiply(0.95, 1.0, 0.95));
        }
        if (this.validateTrainOwnership()) {
            this.train.refreshMaxSpeed();
        }
    }

    public boolean maintainLink(Side linkSide) {
        RollingStock linkedStock = this.linkAt(linkSide).orElse(null);
        if (linkedStock == null) {
            return false;
        }
        if (linkedStock.isLaunched() || linkedStock.isOnElevator()) {
            return false;
        }
        AbstractMinecart linkedEntity = linkedStock.entity();
        boolean sameDimension = this.level().dimension().equals(linkedEntity.level().dimension());
        boolean unlink = false;
        switch (linkSide) {
            case BACK: {
                if (sameDimension) {
                    this.primaryLinkTimeoutTicks = 0;
                    break;
                }
                if (++this.primaryLinkTimeoutTicks > 200) {
                    unlink = true;
                    break;
                }
                return true;
            }
            case FRONT: {
                if (sameDimension) {
                    this.secondaryLinkTimeoutTicks = 0;
                    break;
                }
                if (++this.secondaryLinkTimeoutTicks > 200) {
                    unlink = true;
                    break;
                }
                return true;
            }
        }
        if (unlink) {
            LOGGER.debug("Linked rolling stock in separate dimension, unlinking: {}", (Object)linkedEntity);
            this.unlink(linkSide);
            return false;
        }
        double dist = this.minecart.distanceTo((Entity)linkedEntity);
        if (dist > 8.0) {
            LOGGER.debug("Max distance exceeded, unlinking: {}", (Object)linkedEntity);
            this.unlink(linkSide);
            return false;
        }
        boolean adj1 = this.canCartBeAdjustedBy(linkedStock);
        boolean adj2 = linkedStock.canCartBeAdjustedBy(this);
        Vector2d cart1Pos = new Vector2d(this.minecart.getX(), this.minecart.getZ());
        Vector2d cart2Pos = new Vector2d(linkedEntity.getX(), linkedEntity.getZ());
        Vector2d sub = cart2Pos.sub((Vector2dc)cart1Pos);
        Vector2d unit = sub.equals(0.0, 0.0) ? sub : sub.normalize();
        float optDist = this.getOptimalDistance(linkedStock);
        double stretch = dist - (double)optDist;
        boolean highSpeed = this.isHighSpeed();
        float stiffness = highSpeed ? 0.7f : 0.7f;
        double springX = (double)stiffness * stretch * unit.x();
        double springZ = (double)stiffness * stretch * unit.y();
        springX = RollingStockImpl.limitForce(springX);
        springZ = RollingStockImpl.limitForce(springZ);
        if (adj1) {
            this.minecart.setDeltaMovement(this.minecart.getDeltaMovement().add(springX, 0.0, springZ));
        }
        if (adj2) {
            linkedEntity.setDeltaMovement(linkedEntity.getDeltaMovement().subtract(springX, 0.0, springZ));
        }
        Vector2d cart1Vel = new Vector2d(this.minecart.getDeltaMovement().x(), this.minecart.getDeltaMovement().z());
        Vector2d cart2Vel = new Vector2d(linkedEntity.getDeltaMovement().x(), linkedEntity.getDeltaMovement().z());
        double dot = cart2Vel.sub((Vector2dc)cart1Vel).dot((Vector2dc)unit);
        float damping = highSpeed ? 0.3f : 0.4f;
        double dampX = (double)damping * dot * unit.x();
        double dampZ = (double)damping * dot * unit.y();
        dampX = RollingStockImpl.limitForce(dampX);
        dampZ = RollingStockImpl.limitForce(dampZ);
        if (adj1) {
            this.minecart.setDeltaMovement(this.minecart.getDeltaMovement().add(dampX, 0.0, dampZ));
        }
        if (adj2) {
            linkedEntity.setDeltaMovement(linkedEntity.getDeltaMovement().subtract(dampX, 0.0, dampZ));
        }
        return true;
    }

    private void land() {
        this.launchState = LaunchState.LANDED;
        this.minecart.setMaxSpeedAirLateral(0.4f);
        this.minecart.setMaxSpeedAirVertical(-1.0f);
        this.minecart.setDragAir((double)0.95f);
    }

    private float getOptimalDistance(RollingStock rollingStock) {
        Linkable handler;
        float dist = 0.0f;
        AbstractMinecart abstractMinecart = this.minecart;
        if (abstractMinecart instanceof Linkable) {
            handler = (Linkable)abstractMinecart;
            dist += handler.getOptimalDistance(rollingStock);
        } else {
            dist += 0.78f;
        }
        abstractMinecart = rollingStock.entity();
        if (abstractMinecart instanceof Linkable) {
            handler = (Linkable)abstractMinecart;
            dist += handler.getOptimalDistance(this);
        } else {
            dist += 0.78f;
        }
        return dist;
    }

    private static double limitForce(double force) {
        return Math.copySign(Math.min(Math.abs(force), 6.0), force);
    }

    private float getLinkageDistanceSq(RollingStock rollingStock) {
        Linkable handler;
        float dist = 0.0f;
        AbstractMinecart abstractMinecart = this.minecart;
        if (abstractMinecart instanceof Linkable) {
            handler = (Linkable)abstractMinecart;
            dist += handler.getLinkageDistance(rollingStock);
        } else {
            dist += 1.25f;
        }
        abstractMinecart = rollingStock.entity();
        if (abstractMinecart instanceof Linkable) {
            handler = (Linkable)abstractMinecart;
            dist += handler.getLinkageDistance(this);
        } else {
            dist += 1.25f;
        }
        return dist * dist;
    }

    @Override
    public Optional<GameProfile> owner() {
        Optional<GameProfile> optional;
        AbstractMinecart abstractMinecart = this.entity();
        if (abstractMinecart instanceof Locomotive) {
            Locomotive loco = (Locomotive)abstractMinecart;
            optional = loco.getOwner();
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        if (this.train != null) {
            tag.put("train", (Tag)this.train.toTag());
        }
        if (this.unresolvedBackLink != null) {
            tag.putUUID("backLink", this.unresolvedBackLink);
        } else if (this.backLink != null) {
            tag.putUUID("backLink", this.backLink.entity().getUUID());
        }
        if (this.unresolvedFrontLink != null) {
            tag.putUUID("frontLink", this.unresolvedFrontLink);
        } else if (this.frontLink != null) {
            tag.putUUID("frontLink", this.frontLink.entity().getUUID());
        }
        tag.putBoolean("backAutoLinkEnabled", this.backAutoLinkEnabled);
        tag.putBoolean("frontAutoLinkEnabled", this.frontAutoLinkEnabled);
        tag.putString("launchState", this.launchState.getName());
        tag.putInt("elevatorRemainingTicks", this.elevatorRemainingTicks);
        tag.putInt("preventMountRemainingTicks", this.preventMountRemainingTicks);
        tag.putInt("derailedRemainingTicks", this.derailedRemainingTicks);
        tag.putBoolean("explosionPending", this.explosionPending);
        tag.putBoolean("highSpeed", this.highSpeed);
        return tag;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag tag) {
        this.train = tag.contains("train", 10) ? TrainImpl.fromTag(tag.getCompound("train"), this) : null;
        this.unresolvedBackLink = tag.hasUUID("backLink") ? tag.getUUID("backLink") : null;
        this.unresolvedFrontLink = tag.hasUUID("frontLink") ? tag.getUUID("frontLink") : null;
        this.backAutoLinkEnabled = tag.getBoolean("backAutoLinkEnabled");
        this.frontAutoLinkEnabled = tag.getBoolean("frontAutoLinkEnabled");
        this.launchState = LaunchState.fromName(tag.getString("launchState"));
        this.elevatorRemainingTicks = tag.getInt("elevatorRemainingTicks");
        this.preventMountRemainingTicks = tag.getInt("preventMountRemainingTicks");
        this.derailedRemainingTicks = tag.getInt("derailedRemainingTicks");
        this.explosionPending = tag.getBoolean("explosionPending");
        this.highSpeed = tag.getBoolean("highSpeed");
    }
}

