/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.entity;

import mods.railcraft.api.core.RailcraftConstants;
import mods.railcraft.world.entity.FirestoneItemEntity;
import mods.railcraft.world.entity.vehicle.CargoMinecart;
import mods.railcraft.world.entity.vehicle.EnergyMinecart;
import mods.railcraft.world.entity.vehicle.TankMinecart;
import mods.railcraft.world.entity.vehicle.TrackLayer;
import mods.railcraft.world.entity.vehicle.TrackRelayer;
import mods.railcraft.world.entity.vehicle.TrackRemover;
import mods.railcraft.world.entity.vehicle.TrackUndercutter;
import mods.railcraft.world.entity.vehicle.TunnelBore;
import mods.railcraft.world.entity.vehicle.VoidChestMinecart;
import mods.railcraft.world.entity.vehicle.WorldSpikeMinecart;
import mods.railcraft.world.entity.vehicle.locomotive.CreativeLocomotive;
import mods.railcraft.world.entity.vehicle.locomotive.ElectricLocomotive;
import mods.railcraft.world.entity.vehicle.locomotive.SteamLocomotive;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class RailcraftEntityTypes {
    private static final DeferredRegister<EntityType<?>> deferredRegister = DeferredRegister.create((Registry)BuiltInRegistries.ENTITY_TYPE, (String)"railcraft");
    public static final DeferredHolder<EntityType<?>, EntityType<TankMinecart>> TANK_MINECART = deferredRegister.register("tank_minecart", () -> RailcraftEntityTypes.create("tank_minecart", EntityType.Builder.of(TankMinecart::new, (MobCategory)MobCategory.MISC).clientTrackingRange(256).updateInterval(2).sized(0.98f, 0.7f)));
    public static final DeferredHolder<EntityType<?>, EntityType<CargoMinecart>> CARGO_MINECART = deferredRegister.register("cargo_minecart", () -> RailcraftEntityTypes.create("cargo_minecart", EntityType.Builder.of(CargoMinecart::new, (MobCategory)MobCategory.MISC).clientTrackingRange(256).updateInterval(2).sized(0.98f, 0.7f)));
    public static final DeferredHolder<EntityType<?>, EntityType<EnergyMinecart>> ENERGY_MINECART = deferredRegister.register("energy_minecart", () -> RailcraftEntityTypes.create("energy_minecart", EntityType.Builder.of(EnergyMinecart::new, (MobCategory)MobCategory.MISC).clientTrackingRange(256).updateInterval(2).sized(0.98f, 0.7f)));
    public static final DeferredHolder<EntityType<?>, EntityType<VoidChestMinecart>> VOID_CHEST_MINECART = deferredRegister.register("void_chest_minecart", () -> RailcraftEntityTypes.create("void_chest_minecart", EntityType.Builder.of(VoidChestMinecart::new, (MobCategory)MobCategory.MISC).clientTrackingRange(256).updateInterval(2).sized(0.98f, 0.7f)));
    public static final DeferredHolder<EntityType<?>, EntityType<TrackRemover>> TRACK_REMOVER = deferredRegister.register("track_remover", () -> RailcraftEntityTypes.create("track_remover", EntityType.Builder.of(TrackRemover::new, (MobCategory)MobCategory.MISC).clientTrackingRange(256).updateInterval(2).sized(0.98f, 0.7f)));
    public static final DeferredHolder<EntityType<?>, EntityType<TrackLayer>> TRACK_LAYER = deferredRegister.register("track_layer", () -> RailcraftEntityTypes.create("track_layer", EntityType.Builder.of(TrackLayer::new, (MobCategory)MobCategory.MISC).clientTrackingRange(256).updateInterval(2).sized(0.98f, 0.7f)));
    public static final DeferredHolder<EntityType<?>, EntityType<TrackRelayer>> TRACK_RELAYER = deferredRegister.register("track_relayer", () -> RailcraftEntityTypes.create("track_relayer", EntityType.Builder.of(TrackRelayer::new, (MobCategory)MobCategory.MISC).clientTrackingRange(256).updateInterval(2).sized(0.98f, 0.7f)));
    public static final DeferredHolder<EntityType<?>, EntityType<TrackUndercutter>> TRACK_UNDERCUTTER = deferredRegister.register("track_undercutter", () -> RailcraftEntityTypes.create("track_undercutter", EntityType.Builder.of(TrackUndercutter::new, (MobCategory)MobCategory.MISC).clientTrackingRange(256).updateInterval(2).sized(0.98f, 0.7f)));
    public static final DeferredHolder<EntityType<?>, EntityType<WorldSpikeMinecart>> WORLD_SPIKE = deferredRegister.register("world_spike_minecart", () -> RailcraftEntityTypes.create("world_spike_minecart", EntityType.Builder.of(WorldSpikeMinecart::new, (MobCategory)MobCategory.MISC).clientTrackingRange(256).updateInterval(2).sized(0.98f, 0.7f)));
    public static final DeferredHolder<EntityType<?>, EntityType<TunnelBore>> TUNNEL_BORE = deferredRegister.register("tunnel_bore", () -> RailcraftEntityTypes.create("tunnel_bore", EntityType.Builder.of(TunnelBore::new, (MobCategory)MobCategory.MISC).clientTrackingRange(256).updateInterval(2).sized(6.2f, 3.0f)));
    public static final DeferredHolder<EntityType<?>, EntityType<CreativeLocomotive>> CREATIVE_LOCOMOTIVE = deferredRegister.register("creative_locomotive", () -> RailcraftEntityTypes.create("creative_locomotive", EntityType.Builder.of(CreativeLocomotive::new, (MobCategory)MobCategory.MISC).clientTrackingRange(256).updateInterval(2).sized(0.98f, 1.0f)));
    public static final DeferredHolder<EntityType<?>, EntityType<ElectricLocomotive>> ELECTRIC_LOCOMOTIVE = deferredRegister.register("electric_locomotive", () -> RailcraftEntityTypes.create("electric_locomotive", EntityType.Builder.of(ElectricLocomotive::new, (MobCategory)MobCategory.MISC).clientTrackingRange(256).updateInterval(2).sized(0.98f, 1.0f)));
    public static final DeferredHolder<EntityType<?>, EntityType<SteamLocomotive>> STEAM_LOCOMOTIVE = deferredRegister.register("steam_locomotive", () -> RailcraftEntityTypes.create("steam_locomotive", EntityType.Builder.of(SteamLocomotive::new, (MobCategory)MobCategory.MISC).clientTrackingRange(256).updateInterval(2).sized(0.98f, 1.0f)));
    public static final DeferredHolder<EntityType<?>, EntityType<FirestoneItemEntity>> FIRESTONE = deferredRegister.register("firestone", () -> RailcraftEntityTypes.create("firestone", EntityType.Builder.of(FirestoneItemEntity::new, (MobCategory)MobCategory.MISC).setTrackingRange(64).setUpdateInterval(20)));

    public static void register(IEventBus modEventBus) {
        deferredRegister.register(modEventBus);
    }

    private static <T extends Entity> EntityType<T> create(String registryName, EntityType.Builder<T> builder) {
        return builder.build(RailcraftConstants.rl(registryName).toString());
    }
}

