/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.util;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import mods.railcraft.util.ItemStackKey;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;

public final class Predicates {
    @SafeVarargs
    public static <T> Predicate<T> and(Predicate<? super T> predicate, Predicate<? super T> ... predicates) {
        return new AndPredicate(Lists.asList(predicate, (Object[])predicates));
    }

    public static <T> Predicate<T> and(Collection<? extends Predicate<? super T>> predicates) {
        return new AndPredicate(predicates);
    }

    public static <T> Predicate<T> instanceOf(Class<? extends T> clazz) {
        return clazz::isInstance;
    }

    public static <T> Predicate<T> notOfType(Class<? extends T> clazz) {
        return Predicates.instanceOf(clazz).negate();
    }

    public static <T, O> Predicate<T> distinct(Function<? super T, O> keyFunction) {
        ConcurrentHashMap seen = new ConcurrentHashMap();
        return t -> seen.putIfAbsent(keyFunction.apply(t), Boolean.TRUE) == null;
    }

    public static Predicate<ItemStack> distinctStack() {
        return Predicates.distinct(ItemStackKey::make);
    }

    public static Predicate<BlockState> realBlock(BlockGetter world, BlockPos pos) {
        return state -> state != null && state.isAir();
    }

    public static <T> Predicate<T> alwaysTrue() {
        return __ -> true;
    }

    public static <T> Predicate<T> alwaysFalse() {
        return __ -> false;
    }

    private static class AndPredicate<T>
    implements Predicate<T> {
        private final Collection<? extends Predicate<? super T>> components;

        private AndPredicate(Collection<? extends Predicate<? super T>> predicates) {
            this.components = predicates;
        }

        @Override
        public boolean test(T t) {
            return this.components.stream().allMatch(p -> p.test(t));
        }
    }
}

