/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.season;

import java.time.LocalDate;
import java.time.Month;
import mods.railcraft.RailcraftConfig;
import mods.railcraft.season.Season;
import mods.railcraft.world.entity.vehicle.SeasonalCart;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;

public final class Seasons {
    private static final boolean HARVEST;
    private static final boolean HALLOWEEN;
    private static final boolean CHRISTMAS;
    public static final String GHOST_TRAIN = "Ghost Train";
    public static final String POLAR_EXPRESS = "Polar Express";

    public static boolean isGhostTrain(AbstractMinecart cart) {
        Season season;
        if (cart instanceof SeasonalCart) {
            SeasonalCart seasonal = (SeasonalCart)cart;
            v0 = seasonal.getSeason();
        } else {
            v0 = season = Season.DEFAULT;
        }
        if (season == Season.DEFAULT) {
            return (Boolean)RailcraftConfig.CLIENT.ghostTrainEnabled.get() != false && HALLOWEEN || cart.hasCustomName() && GHOST_TRAIN.equals(cart.getCustomName().getString());
        }
        return season == Season.HALLOWEEN;
    }

    public static boolean isPolarExpress(AbstractMinecart cart) {
        Season season;
        if (cart instanceof SeasonalCart) {
            SeasonalCart seasonal = (SeasonalCart)cart;
            season = seasonal.getSeason();
        } else {
            season = Season.DEFAULT;
        }
        Season season2 = season;
        Level level = cart.level();
        return season2 == Season.DEFAULT ? (Boolean)RailcraftConfig.CLIENT.polarExpressEnabled.get() != false && CHRISTMAS || cart.hasCustomName() && POLAR_EXPRESS.equals(cart.getCustomName().getString()) || ((Biome)level.getBiome(cart.blockPosition()).value()).shouldSnow((LevelReader)level, cart.blockPosition()) : season2 == Season.CHRISTMAS;
    }

    public static boolean isHalloween() {
        return HALLOWEEN;
    }

    static {
        if (((Boolean)RailcraftConfig.COMMON.seasonsEnabled.get()).booleanValue()) {
            LocalDate date = LocalDate.now();
            Month month = date.getMonth();
            int day = date.getDayOfMonth();
            CHRISTMAS = switch ((Integer)RailcraftConfig.COMMON.christmas.get()) {
                case 1 -> true;
                case 2 -> false;
                default -> month == Month.DECEMBER || month == Month.JANUARY;
            };
            HARVEST = switch ((Integer)RailcraftConfig.COMMON.harvest.get()) {
                case 1 -> true;
                case 2 -> false;
                default -> month == Month.OCTOBER || month == Month.NOVEMBER;
            };
            HALLOWEEN = switch ((Integer)RailcraftConfig.COMMON.halloween.get()) {
                case 1 -> true;
                case 2 -> false;
                default -> month == Month.OCTOBER && day >= 21 || month == Month.NOVEMBER && day <= 10;
            };
        } else {
            HARVEST = false;
            HALLOWEEN = false;
            CHRISTMAS = false;
        }
    }
}

