/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.network.to_server;

import mods.railcraft.api.core.RailcraftConstants;
import mods.railcraft.world.item.GogglesItem;
import mods.railcraft.world.item.component.AuraComponent;
import mods.railcraft.world.item.component.RailcraftDataComponents;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record UpdateAuraByKeyMessage(GogglesItem.Aura aura) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<UpdateAuraByKeyMessage> TYPE = new CustomPacketPayload.Type(RailcraftConstants.rl("update_aura_by_key"));
    public static final StreamCodec<FriendlyByteBuf, UpdateAuraByKeyMessage> STREAM_CODEC = StreamCodec.composite(GogglesItem.Aura.STREAM_CODEC, UpdateAuraByKeyMessage::aura, UpdateAuraByKeyMessage::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(UpdateAuraByKeyMessage message, IPayloadContext context) {
        Player player = context.player();
        ItemStack itemStack = player.getItemBySlot(EquipmentSlot.HEAD);
        if (itemStack.getItem() instanceof GogglesItem) {
            itemStack.set(RailcraftDataComponents.AURA, (Object)new AuraComponent(message.aura));
        }
    }
}

