/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.network.to_server;

import mods.railcraft.api.core.RailcraftConstants;
import mods.railcraft.world.level.block.track.outfitted.EmbarkingTrackBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record SetEmbarkingTrackMessage(BlockPos blockPos, int radius) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SetEmbarkingTrackMessage> TYPE = new CustomPacketPayload.Type(RailcraftConstants.rl("set_embarking_track"));
    public static final StreamCodec<FriendlyByteBuf, SetEmbarkingTrackMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, SetEmbarkingTrackMessage::blockPos, (StreamCodec)ByteBufCodecs.VAR_INT, SetEmbarkingTrackMessage::radius, SetEmbarkingTrackMessage::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(SetEmbarkingTrackMessage message, IPayloadContext context) {
        Level level = context.player().level();
        BlockState blockState = level.getBlockState(message.blockPos);
        if (blockState.getBlock() instanceof EmbarkingTrackBlock) {
            level.setBlockAndUpdate(message.blockPos, EmbarkingTrackBlock.setRadius(blockState, message.radius));
        }
    }
}

