/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.mixin;

import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.MinecartFurnace;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={MinecartFurnace.class})
public abstract class MinecartFurnaceMixin
extends AbstractMinecart {
    @Shadow
    private int fuel;
    @Shadow
    public double xPush;
    @Shadow
    public double zPush;

    protected MinecartFurnaceMixin(EntityType<?> type, Level level) {
        super(type, level);
    }

    @Overwrite
    public InteractionResult interact(Player player, InteractionHand hand) {
        InteractionResult ret = super.interact(player, hand);
        if (ret.consumesAction()) {
            return ret;
        }
        ItemStack itemstack = player.getItemInHand(hand);
        int burnTime = itemstack.getBurnTime(null);
        if (burnTime > 0 && this.fuel + burnTime <= 32000) {
            if (!player.getAbilities().instabuild) {
                ItemStack craftRemainder = itemstack.getCraftingRemainingItem();
                itemstack.shrink(1);
                if (itemstack.isEmpty()) {
                    player.setItemInHand(hand, craftRemainder);
                }
            }
            this.fuel += burnTime;
        }
        if (this.fuel > 0) {
            this.xPush = this.getX() - player.getX();
            this.zPush = this.getZ() - player.getZ();
        }
        return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
    }
}

