/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.integrations.emi;

import dev.emi.emi.api.recipe.EmiCraftingRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;

public class DefaultRecipeWrapper
extends EmiCraftingRecipe {
    private final Component info;
    private Consumer<ItemStack> stackModifier;

    public DefaultRecipeWrapper(CustomRecipe customRecipe, ResourceLocation id, boolean shapeless) {
        this(DefaultRecipeWrapper.getInputs(customRecipe), DefaultRecipeWrapper.getOutput(customRecipe), id, shapeless, (Component)Component.empty());
    }

    public DefaultRecipeWrapper(CustomRecipe customRecipe, ResourceLocation id, boolean shapeless, Component info) {
        this(DefaultRecipeWrapper.getInputs(customRecipe), DefaultRecipeWrapper.getOutput(customRecipe), id, shapeless, info);
    }

    public DefaultRecipeWrapper(List<EmiIngredient> input, EmiStack output, ResourceLocation id, boolean shapeless, Component info) {
        super(input, output, id, shapeless);
        this.info = info;
    }

    DefaultRecipeWrapper modifyInputs(Consumer<ItemStack> stackModifier) {
        this.stackModifier = stackModifier;
        return this;
    }

    public void addWidgets(WidgetHolder widgets) {
        super.addWidgets(widgets);
        Font font = Minecraft.getInstance().font;
        int stringWidth = font.width((FormattedText)this.info) / 2;
        widgets.addText(this.info, 82 - stringWidth, 0, -8355712, false);
    }

    private static List<EmiIngredient> getInputs(CustomRecipe recipe) {
        return recipe.getIngredients().stream().map(EmiIngredient::of).toList();
    }

    private static EmiStack getOutput(CustomRecipe recipe) {
        return EmiStack.of((ItemStack)recipe.getResultItem(null));
    }
}

