/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.data.worldgen.features;

import com.google.common.base.Suppliers;
import java.util.List;
import java.util.function.Supplier;
import mods.railcraft.api.core.RailcraftConstants;
import mods.railcraft.tags.RailcraftTags;
import mods.railcraft.world.level.block.DecorativeBlock;
import mods.railcraft.world.level.block.RailcraftBlocks;
import mods.railcraft.world.level.levelgen.feature.QuarriedFeature;
import mods.railcraft.world.level.levelgen.feature.RailcraftFeatures;
import mods.railcraft.world.level.levelgen.feature.configuration.QuarriedConfiguration;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.DiskConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.RuleBasedBlockStateProvider;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;

public class RailcraftOreFeatures {
    private static final int LEAD_VEIN_DIMENSION = 9;
    private static final int TIN_SMALL_VEIN_DIMENSION = 4;
    private static final int TIN_LARGE_VEIN_DIMENSION = 9;
    private static final int SULFUR_VEIN_DIMENSION = 10;
    private static final int ZINC_VEIN_DIMENSION = 6;
    private static final int NICKEL_VEIN_DIMENSION = 7;
    private static final int NICKEL_SMALL_VEIN_DIMENSION = 4;
    private static final int SILVER_VEIN_DIMENSION = 10;
    private static final TagMatchTest STONE_ORE_REPLACEABLES = new TagMatchTest(BlockTags.STONE_ORE_REPLACEABLES);
    private static final TagMatchTest DEEPSLATE_ORE_REPLACEABLES = new TagMatchTest(BlockTags.DEEPSLATE_ORE_REPLACEABLES);
    private static final TagMatchTest QUARRIED_REPLACEABLE_BLOCKS = new TagMatchTest(RailcraftTags.Blocks.QUARRIED_REPLACEABLE_BLOCKS);
    private static final Supplier<List<OreConfiguration.TargetBlockState>> LEAD_ORE_TARGET_LIST = Suppliers.memoize(() -> List.of(OreConfiguration.target((RuleTest)STONE_ORE_REPLACEABLES, (BlockState)((Block)RailcraftBlocks.LEAD_ORE.get()).defaultBlockState()), OreConfiguration.target((RuleTest)DEEPSLATE_ORE_REPLACEABLES, (BlockState)((Block)RailcraftBlocks.DEEPSLATE_LEAD_ORE.get()).defaultBlockState())));
    private static final Supplier<List<OreConfiguration.TargetBlockState>> TIN_ORE_TARGET_LIST = Suppliers.memoize(() -> List.of(OreConfiguration.target((RuleTest)STONE_ORE_REPLACEABLES, (BlockState)((Block)RailcraftBlocks.TIN_ORE.get()).defaultBlockState()), OreConfiguration.target((RuleTest)DEEPSLATE_ORE_REPLACEABLES, (BlockState)((Block)RailcraftBlocks.DEEPSLATE_TIN_ORE.get()).defaultBlockState())));
    private static final Supplier<List<OreConfiguration.TargetBlockState>> SULFUR_ORE_TARGET_LIST = Suppliers.memoize(() -> List.of(OreConfiguration.target((RuleTest)STONE_ORE_REPLACEABLES, (BlockState)((Block)RailcraftBlocks.SULFUR_ORE.get()).defaultBlockState()), OreConfiguration.target((RuleTest)DEEPSLATE_ORE_REPLACEABLES, (BlockState)((Block)RailcraftBlocks.DEEPSLATE_SULFUR_ORE.get()).defaultBlockState())));
    private static final Supplier<List<OreConfiguration.TargetBlockState>> ZINC_ORE_TARGET_LIST = Suppliers.memoize(() -> List.of(OreConfiguration.target((RuleTest)STONE_ORE_REPLACEABLES, (BlockState)((Block)RailcraftBlocks.ZINC_ORE.get()).defaultBlockState()), OreConfiguration.target((RuleTest)DEEPSLATE_ORE_REPLACEABLES, (BlockState)((Block)RailcraftBlocks.DEEPSLATE_ZINC_ORE.get()).defaultBlockState())));
    private static final Supplier<List<OreConfiguration.TargetBlockState>> NICKEL_ORE_TARGET_LIST = Suppliers.memoize(() -> List.of(OreConfiguration.target((RuleTest)STONE_ORE_REPLACEABLES, (BlockState)((Block)RailcraftBlocks.NICKEL_ORE.get()).defaultBlockState()), OreConfiguration.target((RuleTest)DEEPSLATE_ORE_REPLACEABLES, (BlockState)((Block)RailcraftBlocks.DEEPSLATE_NICKEL_ORE.get()).defaultBlockState())));
    private static final Supplier<List<OreConfiguration.TargetBlockState>> SILVER_ORE_TARGET_LIST = Suppliers.memoize(() -> List.of(OreConfiguration.target((RuleTest)STONE_ORE_REPLACEABLES, (BlockState)((Block)RailcraftBlocks.SILVER_ORE.get()).defaultBlockState()), OreConfiguration.target((RuleTest)DEEPSLATE_ORE_REPLACEABLES, (BlockState)((Block)RailcraftBlocks.DEEPSLATE_SILVER_ORE.get()).defaultBlockState())));
    public static final ResourceKey<ConfiguredFeature<?, ?>> LEAD_ORE = RailcraftOreFeatures.createKey("lead_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> TIN_ORE_SMALL = RailcraftOreFeatures.createKey("tin_ore_small");
    public static final ResourceKey<ConfiguredFeature<?, ?>> TIN_ORE_LARGE = RailcraftOreFeatures.createKey("tin_ore_large");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SULFUR_ORE = RailcraftOreFeatures.createKey("sulfur_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SULFUR_ORE_BURIED = RailcraftOreFeatures.createKey("sulfur_ore_buried");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ZINC_ORE = RailcraftOreFeatures.createKey("zinc_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> NICKEL_ORE = RailcraftOreFeatures.createKey("nickel_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> NICKEL_ORE_SMALL = RailcraftOreFeatures.createKey("nickel_ore_small");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SILVER_ORE = RailcraftOreFeatures.createKey("silver_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SILVER_ORE_BURIED = RailcraftOreFeatures.createKey("silver_ore_buried");
    public static final ResourceKey<ConfiguredFeature<?, ?>> QUARRIED_STONE = RailcraftOreFeatures.createKey("quarried_stone");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SALTPETER = RailcraftOreFeatures.createKey("saltpeter");
    public static final ResourceKey<ConfiguredFeature<?, ?>> FIRESTONE = RailcraftOreFeatures.createKey("firestone");

    public static void bootstrap(BootstrapContext<ConfiguredFeature<?, ?>> context) {
        context.register(LEAD_ORE, (Object)new ConfiguredFeature(Feature.ORE, (FeatureConfiguration)new OreConfiguration(LEAD_ORE_TARGET_LIST.get(), 9)));
        context.register(TIN_ORE_SMALL, (Object)new ConfiguredFeature(Feature.ORE, (FeatureConfiguration)new OreConfiguration(TIN_ORE_TARGET_LIST.get(), 4)));
        context.register(TIN_ORE_LARGE, (Object)new ConfiguredFeature(Feature.ORE, (FeatureConfiguration)new OreConfiguration(TIN_ORE_TARGET_LIST.get(), 9)));
        context.register(SULFUR_ORE, (Object)new ConfiguredFeature(Feature.ORE, (FeatureConfiguration)new OreConfiguration(SULFUR_ORE_TARGET_LIST.get(), 10)));
        context.register(SULFUR_ORE_BURIED, (Object)new ConfiguredFeature(Feature.ORE, (FeatureConfiguration)new OreConfiguration(SULFUR_ORE_TARGET_LIST.get(), 10, 0.5f)));
        context.register(ZINC_ORE, (Object)new ConfiguredFeature(Feature.ORE, (FeatureConfiguration)new OreConfiguration(ZINC_ORE_TARGET_LIST.get(), 6)));
        context.register(NICKEL_ORE, (Object)new ConfiguredFeature(Feature.ORE, (FeatureConfiguration)new OreConfiguration(NICKEL_ORE_TARGET_LIST.get(), 7)));
        context.register(NICKEL_ORE_SMALL, (Object)new ConfiguredFeature(Feature.ORE, (FeatureConfiguration)new OreConfiguration(NICKEL_ORE_TARGET_LIST.get(), 4)));
        context.register(SILVER_ORE, (Object)new ConfiguredFeature(Feature.ORE, (FeatureConfiguration)new OreConfiguration(SILVER_ORE_TARGET_LIST.get(), 10)));
        context.register(SILVER_ORE_BURIED, (Object)new ConfiguredFeature(Feature.ORE, (FeatureConfiguration)new OreConfiguration(SILVER_ORE_TARGET_LIST.get(), 10, 0.5f)));
        context.register(QUARRIED_STONE, (Object)new ConfiguredFeature((Feature)((QuarriedFeature)((Object)RailcraftFeatures.QUARRIED_STONE.get())), (FeatureConfiguration)new QuarriedConfiguration((RuleTest)QUARRIED_REPLACEABLE_BLOCKS, (BlockStateProvider)BlockStateProvider.simple((Block)((Block)RailcraftBlocks.DECORATIVE_STONE.variantFor(DecorativeBlock.QUARRIED).get())))));
        context.register(SALTPETER, (Object)new ConfiguredFeature(Feature.DISK, (FeatureConfiguration)new DiskConfiguration(RuleBasedBlockStateProvider.simple((Block)((Block)RailcraftBlocks.SALTPETER_ORE.get())), BlockPredicate.matchesBlocks(List.of(Blocks.DIRT, (Block)RailcraftBlocks.SALTPETER_ORE.get())), (IntProvider)UniformInt.of((int)2, (int)3), 1)));
        context.register(FIRESTONE, (Object)new ConfiguredFeature(Feature.DISK, (FeatureConfiguration)new DiskConfiguration(RuleBasedBlockStateProvider.simple((Block)((Block)RailcraftBlocks.FIRESTONE_ORE.get())), BlockPredicate.matchesBlocks(List.of(Blocks.NETHERRACK, (Block)RailcraftBlocks.FIRESTONE_ORE.get())), (IntProvider)ConstantInt.of((int)1), 1)));
    }

    private static ResourceKey<ConfiguredFeature<?, ?>> createKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)RailcraftConstants.rl(name));
    }
}

