/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.renderer.entity.cart;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import mods.railcraft.api.carts.TunnelBoreHead;
import mods.railcraft.api.core.RailcraftConstants;
import mods.railcraft.client.model.RailcraftModelLayers;
import mods.railcraft.client.model.TunnelBoreModel;
import mods.railcraft.season.Seasons;
import mods.railcraft.world.entity.vehicle.TunnelBore;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.vehicle.AbstractMinecart;

public class TunnelBoreRenderer
extends EntityRenderer<TunnelBore> {
    private static final ResourceLocation TEXTURE = RailcraftConstants.rl("textures/entity/tunnel_bore/tunnel_bore.png");
    protected TunnelBoreModel modelTunnelBore;

    public TunnelBoreRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.shadowRadius = 0.5f;
        this.modelTunnelBore = new TunnelBoreModel(context.bakeLayer(RailcraftModelLayers.TUNNEL_BORE));
    }

    public void render(TunnelBore bore, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource renderTypeBuffer, int packedLight) {
        boolean ghostTrain;
        poseStack.pushPose();
        long var10 = (long)bore.getId() * 493286711L;
        var10 = var10 * var10 * 4392167121L + var10 * 98761L;
        float tx = (((float)(var10 >> 16 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float ty = (((float)(var10 >> 20 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float tz = (((float)(var10 >> 24 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        poseStack.translate(tx, ty, tz);
        poseStack.translate(0.0f, 0.375f, 0.0f);
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f - yaw));
        poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
        float roll = (float)bore.getHurtTime() - partialTicks;
        float damage = Math.max(0.0f, bore.getDamage() - partialTicks);
        if (roll > 0.0f) {
            poseStack.mulPose(Axis.XP.rotationDegrees(Mth.sin((float)roll) * roll * damage / 10.0f * (float)bore.getHurtDir()));
        }
        float colorIntensity = (ghostTrain = Seasons.isGhostTrain((AbstractMinecart)bore)) ? 0.5f : 1.0f;
        TunnelBoreHead head = bore.getBoreHead();
        this.modelTunnelBore.setRenderBoreHead(head != null);
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        this.modelTunnelBore.setBoreHeadRotation(bore.getBoreRotationAngle());
        this.modelTunnelBore.setBoreActive(bore.isMinecartPowered());
        this.modelTunnelBore.setupAnim(bore, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f);
        ResourceLocation textureLocation = this.getTextureLocation(bore);
        VertexConsumer vertexBuilder = renderTypeBuffer.getBuffer(this.modelTunnelBore.renderType(textureLocation));
        this.modelTunnelBore.renderToBuffer(poseStack, vertexBuilder, packedLight, OverlayTexture.NO_OVERLAY, FastColor.ARGB32.colorFromFloat((float)(ghostTrain ? 0.8f : 1.0f), (float)colorIntensity, (float)colorIntensity, (float)colorIntensity));
        poseStack.popPose();
    }

    public ResourceLocation getTextureLocation(TunnelBore entity) {
        TunnelBoreHead head = entity.getBoreHead();
        return head != null ? head.getTextureLocation() : TEXTURE;
    }
}

