/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.renderer.entity.cart;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import mods.railcraft.api.core.RailcraftConstants;
import mods.railcraft.client.model.CubeModel;
import mods.railcraft.client.model.LowSidesMinecartModel;
import mods.railcraft.client.model.RailcraftModelLayers;
import mods.railcraft.client.renderer.entity.cart.ContentsMinecartRenderer;
import mods.railcraft.client.util.CuboidModel;
import mods.railcraft.client.util.CuboidModelRenderer;
import mods.railcraft.client.util.FluidRenderer;
import mods.railcraft.client.util.RenderUtil;
import mods.railcraft.world.entity.vehicle.TankMinecart;
import mods.railcraft.world.level.material.StandardTank;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;

public class TankMinecartRenderer
extends ContentsMinecartRenderer<TankMinecart> {
    private static final ResourceLocation TANK_TEXTURE_LOCATION = RailcraftConstants.rl("textures/entity/minecart/tank.png");
    private final LowSidesMinecartModel<TankMinecart> bodyModel;
    private final LowSidesMinecartModel<TankMinecart> snowModel;
    private final CubeModel tankModel;

    public TankMinecartRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.bodyModel = new LowSidesMinecartModel(context.bakeLayer(RailcraftModelLayers.LOW_SIDES_MINECART));
        this.snowModel = new LowSidesMinecartModel(context.bakeLayer(RailcraftModelLayers.LOW_SIDES_MINECART_SNOW));
        this.tankModel = new CubeModel(RenderType::entityTranslucentCull, context.bakeLayer(RailcraftModelLayers.CUBE));
    }

    @Override
    protected void renderContents(TankMinecart cart, float partialTicks, PoseStack poseStack, MultiBufferSource renderTypeBuffer, int packedLight, int color) {
        VertexConsumer vertexBuilder = renderTypeBuffer.getBuffer(this.tankModel.renderType(TANK_TEXTURE_LOCATION));
        this.tankModel.renderToBuffer(poseStack, vertexBuilder, packedLight, OverlayTexture.NO_OVERLAY, color);
        this.renderTank(cart, poseStack, renderTypeBuffer, packedLight);
        if (cart.hasFilter()) {
            this.renderFilterItem(cart, poseStack, renderTypeBuffer, packedLight);
        }
    }

    private void renderTank(TankMinecart cart, PoseStack poseStack, MultiBufferSource renderTypeBuffer, int packedLight) {
        StandardTank tank = cart.getTankManager();
        FluidStack fluidStack = tank.getFluid();
        float capacity = tank.getCapacity();
        if (capacity > 0.0f && fluidStack.getAmount() > 0) {
            poseStack.pushPose();
            float level = (float)fluidStack.getAmount() / capacity;
            float fluidMaxY = fluidStack.getFluidType().isLighterThanAir() ? 1.0f : Math.min(1.0f, level);
            CuboidModel fluidModel = FluidRenderer.getFluidModel(fluidStack, 0.9921875f, fluidMaxY - 0.0078125f, 0.9921875f, FluidRenderer.FluidType.STILL);
            poseStack.translate(0.00390625f, 0.00390625f, 0.00390625f);
            fluidModel.setPackedLight(RenderUtil.calculateGlowLight(packedLight, fluidStack));
            fluidModel.setPackedOverlay(OverlayTexture.NO_OVERLAY);
            VertexConsumer builder = renderTypeBuffer.getBuffer(Sheets.cutoutBlockSheet());
            CuboidModelRenderer.render(fluidModel, poseStack, builder, RenderUtil.getColorARGB(fluidStack, level), CuboidModelRenderer.FaceDisplay.FRONT, true);
            poseStack.popPose();
            if (cart.isFilling()) {
                poseStack.pushPose();
                float size = 0.3f;
                poseStack.translate(0.35f, 0.0f, 0.35f);
                CuboidModel fillingFluidModel = FluidRenderer.getFluidModel(fluidStack, 0.3f, 0.99609375f, 0.3f, FluidRenderer.FluidType.FLOWING);
                fillingFluidModel.setPackedLight(RenderUtil.calculateGlowLight(packedLight, fluidStack));
                fillingFluidModel.setPackedOverlay(OverlayTexture.NO_OVERLAY);
                CuboidModelRenderer.render(fillingFluidModel, poseStack, builder, RenderUtil.getColorARGB(fluidStack, 1.0f), CuboidModelRenderer.FaceDisplay.FRONT, true);
                poseStack.popPose();
            }
        }
    }

    private void renderFilterItem(TankMinecart cart, PoseStack poseStack, MultiBufferSource renderTypeBuffer, int packedLight) {
        poseStack.pushPose();
        ItemStack itemStack = cart.getFilterItem().copy();
        float scale = 1.2f;
        poseStack.pushPose();
        poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
        poseStack.translate(0.0f, -0.9f, 0.68f);
        poseStack.scale(1.2f, 1.2f, 1.2f);
        Minecraft.getInstance().getItemRenderer().renderStatic(itemStack, ItemDisplayContext.GROUND, packedLight, OverlayTexture.NO_OVERLAY, poseStack, renderTypeBuffer, cart.level(), 0);
        poseStack.popPose();
        poseStack.mulPose(Axis.YN.rotationDegrees(90.0f));
        poseStack.translate(0.0f, -0.9f, 0.68f);
        poseStack.scale(1.2f, 1.2f, 1.2f);
        Minecraft.getInstance().getItemRenderer().renderStatic(itemStack, ItemDisplayContext.GROUND, packedLight, OverlayTexture.NO_OVERLAY, poseStack, renderTypeBuffer, cart.level(), 0);
        poseStack.popPose();
    }

    @Override
    protected EntityModel<TankMinecart> getBodyModel(TankMinecart cart) {
        return this.bodyModel;
    }

    @Override
    protected EntityModel<TankMinecart> getSnowModel(TankMinecart cart) {
        return this.snowModel;
    }
}

