/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.renderer.entity.cart;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import mods.railcraft.client.renderer.entity.cart.StandardMinecartRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;

public abstract class ContentsMinecartRenderer<T extends AbstractMinecart>
extends StandardMinecartRenderer<T> {
    public ContentsMinecartRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    @Override
    public void renderBody(T cart, float partialTicks, PoseStack poseStack, MultiBufferSource renderTypeBuffer, int packedLight, int color) {
        super.renderBody(cart, partialTicks, poseStack, renderTypeBuffer, packedLight, color);
        poseStack.pushPose();
        int displayOffset = cart.getDisplayOffset();
        float scale = 0.75f;
        poseStack.scale(scale, scale, scale);
        if (!cart.getDefaultDisplayBlockState().is(Blocks.AIR)) {
            poseStack.translate(-0.5f, ((float)displayOffset - 8.0f) / 16.0f, 0.5f);
        } else {
            poseStack.translate(-0.5f, ((float)displayOffset - 8.0f) / 16.0f, -0.5f);
        }
        this.renderContents(cart, partialTicks, poseStack, renderTypeBuffer, packedLight, color);
        poseStack.popPose();
    }

    protected void renderContents(T cart, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int color) {
        BlockState blockstate = cart.getDisplayBlockState();
        if (blockstate.getRenderShape() != RenderShape.INVISIBLE) {
            poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
            Minecraft.getInstance().getBlockRenderer().renderSingleBlock(blockstate, poseStack, bufferSource, packedLight, OverlayTexture.NO_OVERLAY);
        }
    }
}

