/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.api.track;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RailShape;
import org.jetbrains.annotations.Nullable;

public class TrackType {
    private final Supplier<? extends BaseRailBlock> flexBlock;
    private final List<Supplier<? extends BaseRailBlock>> spikeMaulVariants;
    private final boolean highSpeed;
    private final boolean electric;
    private final int maxSupportDistance;
    private final EventHandler eventHandler;

    public TrackType(Supplier<? extends BaseRailBlock> flexBlock, List<Supplier<? extends BaseRailBlock>> spikeMaulVariants, boolean highSpeed, boolean electric, int maxSupportDistance, EventHandler eventHandler) {
        this.flexBlock = flexBlock;
        this.spikeMaulVariants = spikeMaulVariants;
        this.highSpeed = highSpeed;
        this.electric = electric;
        this.maxSupportDistance = maxSupportDistance;
        this.eventHandler = eventHandler;
    }

    public BaseRailBlock getFlexBlock() {
        return this.flexBlock.get();
    }

    public List<Supplier<? extends BaseRailBlock>> getSpikeMaulVariants() {
        return this.spikeMaulVariants;
    }

    public boolean isHighSpeed() {
        return this.highSpeed;
    }

    public boolean isElectric() {
        return this.electric;
    }

    public int getMaxSupportDistance() {
        return this.maxSupportDistance;
    }

    public EventHandler getEventHandler() {
        return this.eventHandler;
    }

    public ItemStack getItemStack() {
        return this.getItemStack(1);
    }

    public ItemStack getItemStack(int qty) {
        return new ItemStack((ItemLike)this.getFlexBlock(), qty);
    }

    public static interface EventHandler {
        default public void minecartPass(Level level, AbstractMinecart cart, BlockPos pos) {
        }

        default public Optional<RailShape> getRailShapeOverride(BlockGetter level, BlockPos pos, BlockState blockState, @Nullable AbstractMinecart cart) {
            return Optional.empty();
        }

        default public void entityInside(ServerLevel level, BlockPos pos, BlockState state, Entity entity) {
        }

        default public double getMaxSpeed(Level level, @Nullable AbstractMinecart cart, BlockPos pos) {
            return 0.4;
        }
    }

    public static final class Builder {
        private final Supplier<? extends BaseRailBlock> flexBlock;
        private final ImmutableList.Builder<Supplier<? extends BaseRailBlock>> spikeMaulVariants = ImmutableList.builder();
        private boolean highSpeed;
        private boolean electric;
        private int maxSupportDistance;
        private EventHandler eventHandler = new EventHandler(this){};

        public Builder(Supplier<? extends BaseRailBlock> flexBlock) {
            this.flexBlock = flexBlock;
            this.spikeMaulVariants.add(flexBlock);
        }

        public Builder addSpikeMaulVariant(Supplier<? extends BaseRailBlock> spikeMaulVariant) {
            this.spikeMaulVariants.add(spikeMaulVariant);
            return this;
        }

        public Builder setHighSpeed(boolean highSpeed) {
            this.highSpeed = highSpeed;
            return this;
        }

        public Builder setElectric(boolean electric) {
            this.electric = electric;
            return this;
        }

        public Builder setMaxSupportDistance(int maxSupportDistance) {
            this.maxSupportDistance = maxSupportDistance;
            return this;
        }

        public Builder setEventHandler(EventHandler eventHandler) {
            this.eventHandler = eventHandler;
            return this;
        }

        public TrackType build() {
            return new TrackType(this.flexBlock, (List<Supplier<? extends BaseRailBlock>>)this.spikeMaulVariants.build(), this.highSpeed, this.electric, this.maxSupportDistance, this.eventHandler);
        }
    }
}

