/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.api.carts;

import java.util.Optional;
import net.minecraft.util.StringRepresentable;

public enum Side implements StringRepresentable
{
    FRONT("front"),
    BACK("back");

    private static final StringRepresentable.EnumCodec<Side> CODEC;
    private final String name;

    private Side(String name) {
        this.name = name;
    }

    public Side opposite() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> BACK;
            case 1 -> FRONT;
        };
    }

    public boolean isFront() {
        return this == FRONT;
    }

    public boolean isBack() {
        return this == BACK;
    }

    public String getSerializedName() {
        return this.name;
    }

    public static Optional<Side> fromName(String name) {
        return Optional.ofNullable((Side)CODEC.byName(name));
    }

    static {
        CODEC = StringRepresentable.fromEnum(Side::values);
    }
}

