/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.advancements;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import mods.railcraft.advancements.RailcraftCriteriaTriggers;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public class UseTrackKitTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    public void trigger(ServerPlayer playerEntity, ServerLevel serverLevel, BlockPos blockPos, ItemStack stack) {
        this.trigger(playerEntity, criterionInstance -> criterionInstance.matches(serverLevel, blockPos, stack));
    }

    public static Criterion<TriggerInstance> hasUsedTrackKit() {
        return RailcraftCriteriaTriggers.TRACK_KIT_USE.createCriterion(new TriggerInstance(Optional.empty(), Optional.empty(), Optional.empty()));
    }

    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, Optional<ItemPredicate> item, Optional<LocationPredicate> location) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)ItemPredicate.CODEC.optionalFieldOf("item").forGetter(TriggerInstance::item), (App)LocationPredicate.CODEC.optionalFieldOf("location").forGetter(TriggerInstance::location)).apply((Applicative)instance, TriggerInstance::new));

        public boolean matches(ServerLevel level, BlockPos blockPos, ItemStack stack) {
            return this.item.map(x -> x.test(stack)).orElse(true) != false && this.location.map(x -> x.matches(level, (double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ())).orElse(true) != false;
        }
    }
}

