/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.advancements;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import mods.railcraft.advancements.RailcraftCriteriaTriggers;
import mods.railcraft.util.LevelUtil;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class SpikeMaulUseTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    public void trigger(ServerPlayer player, ItemStack item, ServerLevel serverLevel, BlockPos pos) {
        this.trigger(player, criterionInstance -> criterionInstance.matches(item, serverLevel, pos));
    }

    public static Criterion<TriggerInstance> hasUsedSpikeMaul() {
        return RailcraftCriteriaTriggers.SPIKE_MAUL_USE.createCriterion(new TriggerInstance(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty()));
    }

    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, Optional<NbtPredicate> nbt, Optional<ItemPredicate> tool, Optional<LocationPredicate> location) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)NbtPredicate.CODEC.optionalFieldOf("nbt").forGetter(TriggerInstance::nbt), (App)ItemPredicate.CODEC.optionalFieldOf("tool").forGetter(TriggerInstance::tool), (App)LocationPredicate.CODEC.optionalFieldOf("location").forGetter(TriggerInstance::location)).apply((Applicative)instance, TriggerInstance::new));

        public boolean matches(ItemStack item, ServerLevel level, BlockPos pos) {
            return LevelUtil.getBlockEntity((Level)level, pos).map(x -> x.saveWithoutMetadata((HolderLookup.Provider)level.registryAccess())).map(tag -> this.nbt.map(x -> x.matches((Tag)tag)).orElse(true)).orElse(false) != false && this.tool.map(x -> x.test(item)).orElse(true) != false && this.location.map(x -> x.matches(level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ())).orElse(true) != false;
        }
    }
}

