/*
 * Decompiled with CFR 0.152.
 */
package io.github.frqnny.mostructures.mixin;

import io.github.frqnny.mostructures.init.Structures;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.StructureAccess;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.LakeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LakeFeature.class})
public class LakeFeatureMixin {
    @Inject(at={@At(value="HEAD")}, method={"place(Lnet/minecraft/world/level/levelgen/feature/FeaturePlaceContext;)Z"}, cancellable=true)
    private void mostructures_lakeFix(FeaturePlaceContext<NoneFeatureConfiguration> context, CallbackInfoReturnable<Boolean> info) {
        SectionPos chunkSectionPos = SectionPos.of((BlockPos)context.origin());
        ChunkAccess chunk = context.level().getChunk(context.origin());
        Registry registry = context.level().registryAccess().registryOrThrow(Registries.STRUCTURE);
        StructureManager structureAccessor = context.level().getLevel().structureManager();
        for (Holder entry : registry.getOrCreateTag(Structures.NO_LAKES)) {
            StructureStart startForFeature = structureAccessor.getStartForStructure(chunkSectionPos, (Structure)entry.value(), (StructureAccess)chunk);
            if (startForFeature == null || !startForFeature.isValid()) continue;
            info.setReturnValue((Object)false);
            return;
        }
    }
}

