/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.cobblegengalore.compat.jei;

import cy.jdkdigital.cobblegengalore.CobbleGenGalore;
import cy.jdkdigital.cobblegengalore.common.recipe.BlockGenRecipe;
import cy.jdkdigital.cobblegengalore.compat.jei.CobbleGenGaloreJeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.neoforge.NeoForgeTypes;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.AbstractRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.FluidStack;

public class BlockGenRecipeCategory
extends AbstractRecipeCategory<RecipeHolder<BlockGenRecipe>> {
    private final IDrawable background;

    public BlockGenRecipeCategory(IGuiHelper guiHelper) {
        super(CobbleGenGaloreJeiPlugin.BLOCK_GEN_TYPE, (Component)Component.translatable((String)"jei.cobblegengalore.blockgen"), guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)CobbleGenGalore.BLOCKGEN_IRON_BLOCK.get())), 126, 70);
        this.background = guiHelper.createDrawable(ResourceLocation.fromNamespaceAndPath((String)"cobblegengalore", (String)"textures/gui/jei/block_generator.png"), 0, 0, 126, 70);
    }

    public void draw(RecipeHolder<BlockGenRecipe> recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.background.draw(guiGraphics);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<BlockGenRecipe> recipe, IFocusGroup focuses) {
        BlockGenRecipeCategory.addBlockStateInput(builder, ((BlockGenRecipe)recipe.value()).left, 10, 27).addRichTooltipCallback((iRecipeSlotView, list) -> {
            if (((BlockGenRecipe)recipe.value()).consumeLeft) {
                list.add((FormattedText)Component.translatable((String)"jei.cobblegengalore.consumed").withStyle(ChatFormatting.RED));
            }
        });
        BlockGenRecipeCategory.addBlockStateInput(builder, ((BlockGenRecipe)recipe.value()).right, 101, 27).addRichTooltipCallback((iRecipeSlotView, list) -> {
            if (((BlockGenRecipe)recipe.value()).consumeRight) {
                list.add((FormattedText)Component.translatable((String)"jei.cobblegengalore.consumed").withStyle(ChatFormatting.RED));
            }
        });
        builder.addSlot(RecipeIngredientRole.OUTPUT, 55, 27).addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)((BlockGenRecipe)recipe.value()).result);
        builder.addSlot(RecipeIngredientRole.CATALYST, 55, 27).addItemStacks(BuiltInRegistries.ITEM.getOrCreateTag(CobbleGenGalore.BLOCK_GENERATORS).stream().map(itemHolder -> new ItemStack((ItemLike)itemHolder.value())).toList());
        if (!((BlockGenRecipe)recipe.value()).modifier.isAir()) {
            BlockGenRecipeCategory.addBlockStateInput(builder, ((BlockGenRecipe)recipe.value()).modifier, 55, 46);
        }
    }

    private static IRecipeSlotBuilder addBlockStateInput(IRecipeLayoutBuilder builder, BlockState state, int x, int y) {
        if (!state.getFluidState().isEmpty()) {
            return (IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, x, y).addIngredient((IIngredientType)NeoForgeTypes.FLUID_STACK, (Object)new FluidStack(state.getFluidState().getType(), 1000));
        }
        return (IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, x, y).addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)state.getBlock().asItem()));
    }
}

