/*
 * Decompiled with CFR 0.152.
 */
package com.matyrobbrt.mekanisticrouters.item;

import com.matyrobbrt.mekanisticrouters.MRConfig;
import com.matyrobbrt.mekanisticrouters.MekRouters;
import com.matyrobbrt.mekanisticrouters.item.ChemicalModule1;
import com.mojang.authlib.GameProfile;
import com.mojang.serialization.Codec;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import me.desht.modularrouters.ModularRouters;
import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.client.util.ClientUtil;
import me.desht.modularrouters.client.util.TintColor;
import me.desht.modularrouters.container.ModuleMenu;
import me.desht.modularrouters.core.ModDataComponents;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.item.IPlayerOwned;
import me.desht.modularrouters.item.module.ModuleItem;
import me.desht.modularrouters.item.module.TargetValidation;
import me.desht.modularrouters.logic.compiled.CompiledModule;
import me.desht.modularrouters.logic.compiled.CompiledPlayerModule;
import me.desht.modularrouters.logic.settings.TransferDirection;
import me.desht.modularrouters.util.TranslatableEnum;
import me.desht.modularrouters.util.WildcardedRLMatcher;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.item.context.UseOnContext;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChemicalRefillModule
extends ModuleItem
implements IPlayerOwned {
    private static final TintColor TINT_COLOR = new TintColor(175, 114, 249);

    public ChemicalRefillModule() {
        super(ModItems.moduleProps().component(ModDataComponents.PLAYER_SETTINGS, (Object)CompiledPlayerModule.PlayerSettings.DEFAULT), Compiled::new);
    }

    public void addSettingsInformation(ItemStack stack, List<Component> list) {
        super.addSettingsInformation(stack, list);
        RefillSettings settings = (RefillSettings)stack.getOrDefault(MekRouters.REFILL_SETTINGS, (Object)RefillSettings.DEFAULT);
        ResolvableProfile profile = (ResolvableProfile)stack.get(ModDataComponents.OWNER);
        String owner = profile == null ? "-" : profile.gameProfile().getName();
        list.add((Component)ClientUtil.xlate((String)"modularrouters.itemText.security.owner", (Object[])new Object[]{ClientUtil.colorText((Object)owner, (ChatFormatting[])new ChatFormatting[]{ChatFormatting.AQUA})}).withStyle(ChatFormatting.YELLOW));
        MutableComponent c = ClientUtil.xlate((String)"modularrouters.itemText.misc.operation", (Object[])new Object[0]).withStyle(ChatFormatting.YELLOW).append(": ").append((Component)ClientUtil.xlate((String)"block.modularrouters.modular_router", (Object[])new Object[0]).append(" ").append(TransferDirection.FROM_ROUTER.getSymbol()).append(" ").append((Component)ClientUtil.xlate((String)settings.section().getTranslationKey(), (Object[])new Object[0])).withStyle(ChatFormatting.AQUA));
        list.add((Component)c);
    }

    public MenuType<? extends ModuleMenu> getMenuType() {
        return (MenuType)MekRouters.CHEMICAL_REFILL_MODULE_MENU.get();
    }

    public boolean isDirectional() {
        return false;
    }

    public InteractionResult useOn(UseOnContext ctx) {
        if (ctx.getLevel().isClientSide) {
            return InteractionResult.SUCCESS;
        }
        if (ctx.getPlayer() != null && ctx.getPlayer().isSteppingCarefully()) {
            this.setOwner(ctx.getItemInHand(), ctx.getPlayer());
            ctx.getPlayer().displayClientMessage((Component)Component.translatable((String)"modularrouters.itemText.security.owner", (Object[])new Object[]{ctx.getPlayer().getDisplayName()}), false);
            return InteractionResult.SUCCESS;
        }
        return super.useOn(ctx);
    }

    public TintColor getItemTint() {
        return TINT_COLOR;
    }

    public int getEnergyCost(ItemStack stack) {
        return MRConfig.CHEMICAL_REFILL_MODULE_FE.getAsInt();
    }

    public void doModuleValidation(ItemStack stack, ServerPlayer player) {
        TargetValidation v = ModularRouters.getDimensionBlacklist().test(player.level().dimension().location()) ? TargetValidation.BAD_DIMENSION : TargetValidation.OK;
        MutableComponent msg = Component.translatable((String)v.translationKey()).withStyle(v.getColor());
        player.displayClientMessage((Component)msg, false);
    }

    public record RefillSettings(Section section) {
        public static final RefillSettings DEFAULT = new RefillSettings(Section.ARMOR);
        public static final Codec<RefillSettings> CODEC = StringRepresentable.fromEnum(Section::values).optionalFieldOf("section", (Object)Section.ARMOR).xmap(RefillSettings::new, RefillSettings::section).codec();
        public static final StreamCodec<FriendlyByteBuf, RefillSettings> STREAM_CODEC = NeoForgeStreamCodecs.enumCodec(Section.class).map(RefillSettings::new, RefillSettings::section);
    }

    public static enum Section implements TranslatableEnum,
    StringRepresentable
    {
        MAIN("main"),
        MAIN_NO_HOTBAR("main_no_hotbar"),
        ARMOR("armor"),
        OFFHAND("offhand");

        private final String name;

        private Section(String name) {
            this.name = name;
        }

        public String getTranslationKey() {
            return "modularrouters.guiText.label.playerSect." + this.name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }

    public static class Compiled
    extends CompiledModule {
        private final RefillSettings settings;
        private final GameProfile playerProfile;

        protected Compiled(@Nullable ModularRouterBlockEntity router, ItemStack stack) {
            super(router, stack);
            this.settings = (RefillSettings)stack.getOrDefault(MekRouters.REFILL_SETTINGS, (Object)RefillSettings.DEFAULT);
            this.playerProfile = ((IPlayerOwned)stack.getItem()).getOwnerProfile(stack).orElse(null);
        }

        public boolean execute(@NotNull ModularRouterBlockEntity router) {
            if (this.playerProfile == null) {
                return false;
            }
            ServerPlayer player = router.nonNullLevel().getServer().getPlayerList().getPlayer(this.playerProfile.getId());
            if (player == null || this.isDimensionBlacklisted(router, (Player)player)) {
                return false;
            }
            IChemicalHandler chemicalHandler = (IChemicalHandler)router.getBufferCapability(MekRouters.ITEM_CHEMICAL);
            if (chemicalHandler == null) {
                return false;
            }
            long[] rate = new long[]{ChemicalModule1.getRouterMaxTransfer(router)};
            Compiled.forEachItem((Player)player, this.settings.section, stack -> {
                if (!this.getFilter().test(stack)) {
                    return false;
                }
                IChemicalHandler targetHandler = (IChemicalHandler)stack.getCapability(MekRouters.ITEM_CHEMICAL);
                if (targetHandler == null) {
                    return false;
                }
                ChemicalStack newStack = MekRouters.tryChemicalTransfer(chemicalHandler, targetHandler, rate[0], false);
                if (newStack.isEmpty() || newStack.isRadioactive() && !MRConfig.RADIATION_TRANSFER.getAsBoolean()) {
                    return false;
                }
                ChemicalStack remainder = MekRouters.tryChemicalTransfer(chemicalHandler, targetHandler, newStack.getAmount(), true);
                rate[0] = rate[0] - (newStack.getAmount() - remainder.getAmount());
                return rate[0] <= 0L;
            });
            return false;
        }

        private static void forEachItem(Player player, Section section, Predicate<ItemStack> pred) {
            switch (section.ordinal()) {
                case 0: {
                    ItemStack item;
                    Iterator iterator = player.getInventory().items.iterator();
                    while (iterator.hasNext() && ((item = (ItemStack)iterator.next()).isEmpty() || !pred.test(item))) {
                    }
                    break;
                }
                case 1: {
                    ItemStack item;
                    for (int i = Inventory.getSelectionSize(); i < player.getInventory().items.size() && ((item = (ItemStack)player.getInventory().items.get(i)).isEmpty() || !pred.test(item)); ++i) {
                    }
                    break;
                }
                case 2: {
                    ItemStack item;
                    Iterator i = player.getInventory().armor.iterator();
                    while (i.hasNext() && ((item = (ItemStack)i.next()).isEmpty() || !pred.test(item))) {
                    }
                    break;
                }
                case 3: {
                    ItemStack item = player.getOffhandItem();
                    if (item.isEmpty()) break;
                    pred.test(item);
                }
            }
        }

        private boolean isDimensionBlacklisted(ModularRouterBlockEntity router, Player player) {
            WildcardedRLMatcher matcher = ModularRouters.getDimensionBlacklist();
            return matcher.test(router.nonNullLevel().dimension().location()) || matcher.test(player.level().dimension().location());
        }
    }
}

