/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.cristellib.autoconfig;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.cristelknight.cristellib.autoconfig.ACInfoData;
import de.cristelknight.cristellib.config.simple.ConfigRegistry;
import de.cristelknight.cristellib.config.simple.ConfigSettings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.Util;

public record ACConfig(boolean disableAutoConfig, boolean disableAutoConfigScreens, String autoConfigSubPath, List<String> blacklistedMods, List<String> clientExcludedMods, List<String> modOverrideWhitelist) {
    public static final Codec<ACConfig> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.BOOL.fieldOf("disableAutoConfig").forGetter(ACConfig::disableAutoConfig), (App)Codec.BOOL.fieldOf("disableAutoConfigScreens").forGetter(ACConfig::disableAutoConfigScreens), (App)Codec.STRING.fieldOf("autoConfigSubPath").forGetter(ACConfig::autoConfigSubPath), (App)Codec.list((Codec)Codec.STRING).fieldOf("blacklistedMods").forGetter(ACConfig::blacklistedMods), (App)Codec.list((Codec)Codec.STRING).fieldOf("clientExcludedMods").forGetter(ACConfig::clientExcludedMods), (App)Codec.list((Codec)Codec.STRING).fieldOf("modOverrideWhitelist").forGetter(ACConfig::modOverrideWhitelist)).apply((Applicative)builder, ACConfig::new));
    public static final ConfigSettings<ACConfig> SETTINGS = new ConfigSettings<ACConfig>(){

        @Override
        public String getSubPath() {
            return "cristellib/auto_config_settings";
        }

        @Override
        public Codec<ACConfig> getCodec() {
            return CODEC;
        }

        @Override
        public ACConfig getDefault() {
            return new ACConfig(false, false, "cristellib/", ACInfoData.getBlackListedMods(), ACInfoData.getClientBlackListedMods(), List.of());
        }

        @Override
        public String getHeader() {
            return "Auto-Config Settings\nThe Config for Cristel Lib's automated structure config generation.\n";
        }

        @Override
        public HashMap<String, String> getComments() {
            return (HashMap)Util.make(new HashMap(), map -> {
                map.put("disableAutoConfig", "Disable automatic structure config generation.");
                map.put("disableAutoConfigScreens", "Disable automatic screen generation for structure configs.");
                map.put("autoConfigSubPath", "Set the default sub path of all automatically generated configs. Requires a RESTART to apply!");
                map.put("blacklistedMods", "Mods where automatic structure config generation is disabled.");
                map.put("clientExcludedMods", "Mods where automatic screen generation for structure configs is disabled.");
                map.put("modOverrideWhitelist", "This list lets you override the default settings provided by mod authors.\nIf you add a mod that is blacklisted by default (in the two other lists)\nyou can now remove it without it getting added back automatically.\nProceed at your own risk.");
            });
        }
    };

    public static void updateConfig() {
        ACConfig config = ConfigRegistry.get(ACConfig.class);
        ArrayList<String> defaultBlacklistedMods = new ArrayList<String>(SETTINGS.getDefault().blacklistedMods());
        ArrayList<String> defaultClientExcludedMods = new ArrayList<String>(SETTINGS.getDefault().clientExcludedMods());
        ArrayList<String> modOverrideWhitelist = new ArrayList<String>(config.modOverrideWhitelist());
        ArrayList<String> blacklistedMods = new ArrayList<String>(config.blacklistedMods());
        ArrayList<String> clientExcludedMods = new ArrayList<String>(config.clientExcludedMods());
        if (defaultBlacklistedMods.isEmpty() && defaultClientExcludedMods.isEmpty() && modOverrideWhitelist.isEmpty()) {
            return;
        }
        blacklistedMods.removeAll(defaultBlacklistedMods);
        clientExcludedMods.removeAll(defaultClientExcludedMods);
        ArrayList<String> allDefaultBlacklists = new ArrayList<String>(SETTINGS.getDefault().blacklistedMods());
        allDefaultBlacklists.addAll(SETTINGS.getDefault().clientExcludedMods());
        modOverrideWhitelist.retainAll(allDefaultBlacklists);
        defaultBlacklistedMods.removeAll(modOverrideWhitelist);
        defaultClientExcludedMods.removeAll(modOverrideWhitelist);
        blacklistedMods.addAll(defaultBlacklistedMods);
        clientExcludedMods.addAll(defaultClientExcludedMods);
        ConfigRegistry.updateAndSave(new ACConfig(config.disableAutoConfig(), config.disableAutoConfigScreens(), config.autoConfigSubPath(), blacklistedMods, clientExcludedMods, modOverrideWhitelist));
    }

    static {
        ConfigRegistry.registerWithScreen(ACConfig.class, SETTINGS, "cristellib", "Auto-config", ACConfig::updateConfig);
    }
}

