/*
 * Decompiled with CFR 0.152.
 */
package commoble.morered.wires;

import commoble.morered.MoreRed;
import commoble.morered.api.ChanneledPowerSupplier;
import commoble.morered.util.DirectionHelper;
import commoble.morered.wires.AbstractWireBlock;
import commoble.morered.wires.ColoredCableBlock;
import commoble.morered.wires.WireBlockEntity;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ColoredCableBlockEntity
extends WireBlockEntity {
    protected Map<Direction, ChanneledPowerSupplier> sidedPowerSuppliers = (Map)Util.make(new EnumMap(Direction.class), map -> {
        for (int i = 0; i < 6; ++i) {
            Direction dir = Direction.from3DDataValue((int)i);
            map.put(dir, new SidedPowerSupplier(dir));
        }
    });

    public ColoredCableBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType<ColoredCableBlockEntity>)((BlockEntityType)MoreRed.get().coloredNetworkCableBeType.get()), pos, state);
    }

    public ColoredCableBlockEntity(BlockEntityType<ColoredCableBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public ChanneledPowerSupplier getChanneledPower(Direction side) {
        return side == null ? null : this.sidedPowerSuppliers.get(side);
    }

    protected class SidedPowerSupplier
    implements ChanneledPowerSupplier {
        private final Direction side;

        public SidedPowerSupplier(Direction side) {
            this.side = side;
        }

        @Override
        public int getPowerOnChannel(Level world, BlockPos wirePos, BlockState wireState, @Nullable Direction wireFace, int channel) {
            ColoredCableBlockEntity cable = ColoredCableBlockEntity.this;
            BlockState state = cable.getBlockState();
            Block block = state.getBlock();
            if (!(block instanceof ColoredCableBlock)) {
                return 0;
            }
            if (channel != ((ColoredCableBlock)block).getDyeColor().ordinal()) {
                return 0;
            }
            int sideIndex = this.side.ordinal();
            if (((Boolean)state.getValue((Property)AbstractWireBlock.INTERIOR_FACES[sideIndex])).booleanValue()) {
                return cable.getPower(sideIndex);
            }
            if (wireFace != null) {
                return cable.getPower(wireFace.ordinal());
            }
            int output = 0;
            for (int subSide = 0; subSide < 4; ++subSide) {
                int actualSubSide = DirectionHelper.uncompressSecondSide(sideIndex, subSide);
                if (!((Boolean)state.getValue((Property)AbstractWireBlock.INTERIOR_FACES[actualSubSide])).booleanValue()) continue;
                output = Math.max(output, cable.getPower(actualSubSide));
            }
            return output;
        }
    }
}

