/*
 * Decompiled with CFR 0.152.
 */
package commoble.morered.plate_blocks;

import commoble.morered.util.BlockStateUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class PlateBlockStateProperties {
    public static final DirectionProperty ATTACHMENT_DIRECTION = BlockStateProperties.FACING;
    public static final IntegerProperty ROTATION = IntegerProperty.create((String)"rotation", (int)0, (int)3);
    public static final BooleanProperty INPUT_A = BooleanProperty.create((String)"input_a");
    public static final BooleanProperty INPUT_B = BooleanProperty.create((String)"input_b");
    public static final BooleanProperty INPUT_C = BooleanProperty.create((String)"input_c");

    public static Direction getOutputDirection(BlockState state) {
        if (!state.hasProperty((Property)ATTACHMENT_DIRECTION) || !state.hasProperty((Property)ROTATION)) {
            return Direction.DOWN;
        }
        Direction attachmentDirection = (Direction)state.getValue((Property)ATTACHMENT_DIRECTION);
        int rotationIndex = (Integer)state.getValue((Property)ROTATION);
        return BlockStateUtil.getOutputDirection(attachmentDirection, rotationIndex);
    }

    public static BlockState getStateForPlacedGatePlate(BlockState state, BlockPlaceContext context) {
        BlockPos placePos = context.getClickedPos();
        Direction faceOfAdjacentBlock = context.getClickedFace();
        Direction directionTowardAdjacentBlock = faceOfAdjacentBlock.getOpposite();
        Vec3 relativeHitVec = context.getClickLocation().subtract(Vec3.atLowerCornerOf((Vec3i)placePos));
        return PlateBlockStateProperties.getStateForPlacedGatePlate(state, placePos, directionTowardAdjacentBlock, relativeHitVec);
    }

    public static BlockState getStateForPlacedGatePlate(BlockState state, BlockPos placePos, Direction directionTowardAdjacentBlock, Vec3 relativeHitVec) {
        Direction outputDirection = BlockStateUtil.getOutputDirectionFromRelativeHitVec(relativeHitVec, directionTowardAdjacentBlock);
        int rotationIndex = BlockStateUtil.getRotationIndexForDirection(directionTowardAdjacentBlock, outputDirection);
        if (state.hasProperty((Property)ATTACHMENT_DIRECTION) && state.hasProperty((Property)ROTATION)) {
            return (BlockState)((BlockState)state.setValue((Property)ATTACHMENT_DIRECTION, (Comparable)directionTowardAdjacentBlock)).setValue((Property)ROTATION, (Comparable)Integer.valueOf(rotationIndex));
        }
        return state;
    }
}

