/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.turbine;

final class RpmUpdateTracker {
    private int _ticksSinceLastUpdate = 0;
    private int _ticksBetweenUpdates;
    private int _ticksBetweenUrgentUpdates;
    private float _value = 0.0f;
    private float _minimumDifference;
    private float _maximumDifference;

    public RpmUpdateTracker(int minimumTicksBetweenUpdates, int minimumTicksBetweenUrgentUpdates, float minimumSpreadForUpdate, float maximumSpreadForUpdate) {
        this._ticksBetweenUpdates = minimumTicksBetweenUpdates;
        this._ticksBetweenUrgentUpdates = Math.min(this._ticksBetweenUpdates, minimumTicksBetweenUrgentUpdates);
        this._minimumDifference = minimumSpreadForUpdate;
        this._maximumDifference = Math.max(this._minimumDifference, maximumSpreadForUpdate);
    }

    public void setValue(float value) {
        this._value = value;
        this._ticksSinceLastUpdate = 0;
    }

    public void reset() {
        this._ticksSinceLastUpdate = 0;
    }

    public boolean shouldUpdate(float currentValue) {
        ++this._ticksSinceLastUpdate;
        if (0.0f == this._value && currentValue > 0.0f || 0.0f == currentValue && this._value > 0.0f) {
            this._ticksSinceLastUpdate = 0;
            this._value = currentValue;
            return true;
        }
        if (this._ticksSinceLastUpdate < this._ticksBetweenUrgentUpdates) {
            return false;
        }
        float spread = Math.abs(currentValue - this._value);
        if (spread >= this._maximumDifference) {
            this._ticksSinceLastUpdate = 0;
            this._value = currentValue;
            return true;
        }
        if (this._ticksSinceLastUpdate < this._ticksBetweenUpdates) {
            return false;
        }
        if (spread >= this._minimumDifference) {
            this._ticksSinceLastUpdate = 0;
            this._value = currentValue;
            return true;
        }
        this._ticksSinceLastUpdate = this._ticksBetweenUpdates;
        return false;
    }
}

