/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.reprocessor.part;

import it.zerono.mods.extremereactors.gamecontent.multiblock.reprocessor.MultiblockReprocessor;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reprocessor.container.ReprocessorAccessPortContainer;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reprocessor.part.AbstractReprocessorEntity;
import it.zerono.mods.zerocore.lib.data.IoDirection;
import it.zerono.mods.zerocore.lib.item.ItemHelper;
import it.zerono.mods.zerocore.lib.item.inventory.handler.ItemHandlerModifiableForwarder;
import it.zerono.mods.zerocore.lib.multiblock.cuboid.AbstractCuboidMultiblockController;
import it.zerono.mods.zerocore.lib.multiblock.cuboid.PartPosition;
import it.zerono.mods.zerocore.lib.multiblock.validation.IMultiblockValidator;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class ReprocessorAccessPortEntity
extends AbstractReprocessorEntity
implements MenuProvider {
    private final IoDirection _direction;
    private final ItemHandlerModifiableForwarder _forwarder;

    public ReprocessorAccessPortEntity(BlockEntityType<?> type, IoDirection direction, BlockPos position, BlockState blockState) {
        super(type, position, blockState);
        this._direction = direction;
        this._forwarder = new ItemHandlerModifiableForwarder(ItemHelper.EMPTY_ITEM_HANDLER);
    }

    public IItemHandler getHandler() {
        return this._forwarder;
    }

    public IoDirection getDirection() {
        return this._direction;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int windowId, Inventory inventory, Player player) {
        return new ReprocessorAccessPortContainer(windowId, inventory, this);
    }

    public Component getDisplayName() {
        return super.getPartDisplayName();
    }

    public boolean canOpenGui(Level world, BlockPos position, BlockState state) {
        return this.isMachineAssembled();
    }

    public void onPostMachineAssembled(MultiblockReprocessor controller) {
        super.onPostMachineAssembled((AbstractCuboidMultiblockController)controller);
        this._forwarder.setHandler(this.getItemInventory(this._direction));
    }

    public void onPostMachineBroken() {
        super.onPostMachineBroken();
        this._forwarder.setHandler(ItemHelper.EMPTY_ITEM_HANDLER);
    }

    @Override
    public boolean isGoodForPosition(PartPosition position, IMultiblockValidator validatorCallback) {
        return this._direction.isInput() && PartPosition.TopFace == position || this._direction.isOutput() && position.isFace() || super.isGoodForPosition(position, validatorCallback);
    }
}

