/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.reactor;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import it.zerono.mods.extremereactors.Log;
import it.zerono.mods.extremereactors.api.IMapping;
import it.zerono.mods.extremereactors.api.internal.AbstractNamedValue;
import it.zerono.mods.extremereactors.api.reactor.Reactant;
import it.zerono.mods.extremereactors.api.reactor.ReactantType;
import it.zerono.mods.extremereactors.api.reactor.ReactantsRegistry;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.data.nbt.ISyncableEntity;
import it.zerono.mods.zerocore.lib.data.stack.IStackAdapter;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;

public class ReactantStack
implements ISyncableEntity {
    public static final ReactantStack EMPTY = new ReactantStack();
    public static final IStackAdapter<ReactantStack, Reactant> ADAPTER = new IStackAdapter<ReactantStack, Reactant>(){

        public Optional<Reactant> getContent(ReactantStack stack) {
            return stack.getReactant();
        }

        public int getAmount(ReactantStack stack) {
            return stack.getAmount();
        }

        public ReactantStack setAmount(ReactantStack stack, int amount) {
            if (!stack.isEmpty()) {
                stack.setAmount(amount);
            }
            return stack;
        }

        public ReactantStack modifyAmount(ReactantStack stack, int delta) {
            if (!stack.isEmpty()) {
                stack.modifyAmount(delta);
            }
            return stack;
        }

        public ReactantStack getEmptyStack() {
            return EMPTY;
        }

        public boolean isEmpty(ReactantStack stack) {
            return stack.isEmpty();
        }

        public boolean isStackContentEqual(ReactantStack stack1, ReactantStack stack2) {
            return stack1.isReactantEqual(stack2);
        }

        public boolean isContentEqual(Reactant content1, Reactant content2) {
            return content1.equals(content2);
        }

        public boolean areIdentical(ReactantStack stack1, ReactantStack stack2) {
            return ReactantStack.areIdentical(stack1, stack2);
        }

        public ReactantStack create(Reactant content, int amount) {
            return new ReactantStack(content, amount);
        }

        public ReactantStack create(ReactantStack stack) {
            return new ReactantStack(stack);
        }

        public ReactantStack[] createArray(int length) {
            return new ReactantStack[length];
        }

        public List<ReactantStack> createList() {
            return Lists.newArrayList();
        }

        public Set<ReactantStack> createSet() {
            return Sets.newHashSet();
        }

        public ReactantStack deserialize(HolderLookup.Provider registries, Tag input) {
            if (input instanceof CompoundTag) {
                CompoundTag compound = (CompoundTag)input;
                ReactantStack stack = new ReactantStack();
                stack.syncDataFrom(compound, registries, ISyncableEntity.SyncReason.FullSync);
                return stack;
            }
            throw new IllegalArgumentException("Input must be a CompoundTag instance");
        }

        public Tag serialize(HolderLookup.Provider registries, ReactantStack stack, Tag output) {
            if (output instanceof CompoundTag) {
                CompoundTag tag = (CompoundTag)output;
                return stack.syncDataTo(tag, registries, ISyncableEntity.SyncReason.FullSync);
            }
            throw new IllegalArgumentException("Output must be a CompoundTag instance");
        }

        public String toString(ReactantStack stack) {
            return stack.toString();
        }

        public <T> T map(ReactantStack stack, Function<Reactant, T> mapper, T defaultValue) {
            return stack.isEmpty() ? defaultValue : mapper.apply(stack._reactant);
        }

        public <T> T map(ReactantStack stack, IntFunction<T> mapper, T defaultValue) {
            return stack.isEmpty() ? defaultValue : mapper.apply(stack._amount);
        }

        public <T> T map(ReactantStack stack, BiFunction<Reactant, Integer, T> mapper, T defaultValue) {
            return stack.isEmpty() ? defaultValue : mapper.apply(stack._reactant, stack._amount);
        }

        public void accept(ReactantStack stack, Consumer<Reactant> consumer) {
            if (!stack.isEmpty()) {
                consumer.accept(stack._reactant);
            }
        }

        public void accept(ReactantStack stack, IntConsumer consumer) {
            if (!stack.isEmpty()) {
                consumer.accept(stack._amount);
            }
        }

        public void accept(ReactantStack stack, BiConsumer<Reactant, Integer> consumer) {
            if (!stack.isEmpty()) {
                consumer.accept(stack._reactant, stack._amount);
            }
        }
    };
    private Reactant _reactant;
    private int _amount;
    private boolean _isEmpty;

    public ReactantStack(Reactant reactant) {
        this(reactant, 0);
    }

    public ReactantStack(Reactant reactant, int amount) {
        this._reactant = reactant;
        this._amount = amount;
        this.updateEmptyState();
    }

    public ReactantStack(ReactantStack other) {
        this(other._reactant, other._amount);
    }

    public ReactantStack(IMapping<TagKey<Item>, Reactant> mapping, int itemCount) {
        this(mapping.getProduct(), mapping.getProductAmount(itemCount));
    }

    public static ReactantStack createFrom(FriendlyByteBuf data) {
        if (!data.readBoolean()) {
            return EMPTY;
        }
        int amount = data.readInt();
        String name = data.readUtf(1024);
        return ReactantsRegistry.get(name).map(reactant -> new ReactantStack((Reactant)reactant, amount)).orElse(EMPTY);
    }

    public void writeTo(FriendlyByteBuf data) {
        if (this.isEmpty()) {
            data.writeBoolean(false);
        } else {
            data.writeBoolean(true);
            data.writeInt(this._amount);
            data.writeUtf(this._reactant.getName());
        }
    }

    public static boolean areIdentical(ReactantStack stack1, ReactantStack stack2) {
        return stack1.isReactantEqual(stack2) && stack1.getAmount() == stack2.getAmount();
    }

    public boolean isEmpty() {
        if (this == EMPTY) {
            return true;
        }
        if (this.getReactant().isPresent()) {
            return this.getAmount() <= 0;
        }
        return true;
    }

    public Optional<Reactant> getReactant() {
        return this._isEmpty ? Optional.empty() : Optional.ofNullable(this._reactant);
    }

    public int getAmount() {
        return this._isEmpty ? 0 : this._amount;
    }

    public void setAmount(int amount) {
        this._amount = Math.max(0, amount);
        this.updateEmptyState();
    }

    public void modifyAmount(int delta) {
        this.setAmount(this.getAmount() + delta);
    }

    public boolean isReactantEqual(Reactant other) {
        return !this.isEmpty() && this.getReactant().map(reactant -> reactant.equals(other)).orElse(false) != false;
    }

    public boolean isReactantEqual(ReactantStack other) {
        return !this.isEmpty() && !other.isEmpty() && this.getReactant().equals(other.getReactant());
    }

    public boolean contains(ReactantType type) {
        return this.getReactant().filter(reactant -> reactant.test(type)).isPresent();
    }

    public boolean containsFuel() {
        return this.contains(ReactantType.Fuel);
    }

    public boolean containsWaste() {
        return this.contains(ReactantType.Waste);
    }

    public ReactantStack copyWithAmount(int amount) {
        return new ReactantStack(this._reactant, amount);
    }

    public void syncDataFrom(CompoundTag data, HolderLookup.Provider registries, ISyncableEntity.SyncReason syncReason) {
        String name;
        if (data.contains("rstack_name") && !Strings.isNullOrEmpty((String)(name = data.getString("rstack_name"))) && !"EMPTY".equals(name)) {
            CodeHelper.optionalIfPresentOrElse(ReactantsRegistry.get(name), reactant -> {
                if (data.contains("rstack_amount")) {
                    this._reactant = reactant;
                    this.setAmount(data.getInt("rstack_amount"));
                } else {
                    Log.LOGGER.warn(Log.REACTOR, "Loading a ReactantStack containing an unknown amount");
                    this._reactant = null;
                    this.setAmount(0);
                }
            }, () -> {
                Log.LOGGER.warn(Log.REACTOR, "Loading a ReactantStack containing an unknown Reactant: {}", (Object)name);
                this._reactant = null;
                this.setAmount(0);
            });
        }
        this.updateEmptyState();
    }

    public CompoundTag syncDataTo(CompoundTag data, HolderLookup.Provider registries, ISyncableEntity.SyncReason syncReason) {
        if (!this.isEmpty()) {
            data.putString("rstack_name", this.getReactant().map(AbstractNamedValue::getName).orElse("EMPTY"));
            data.putInt("rstack_amount", this.getAmount());
        }
        return data;
    }

    public String toString() {
        return this.isEmpty() ? "EMPTY" : String.format("%s, %d mB", this.getReactant().map(AbstractNamedValue::getName).orElse("NO REACTANT"), this.getAmount());
    }

    private ReactantStack() {
        this._reactant = null;
        this._amount = 0;
    }

    private void updateEmptyState() {
        this._isEmpty = this.isEmpty();
    }
}

