/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.part;

import it.zerono.mods.extremereactors.ExtremeReactors;
import it.zerono.mods.extremereactors.gamecontent.Content;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.container.FluidizerSolidInjectorContainer;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.part.AbstractFluidizerEntity;
import it.zerono.mods.zerocore.base.BaseHelper;
import it.zerono.mods.zerocore.base.CommonConstants;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.DebuggableHelper;
import it.zerono.mods.zerocore.lib.IDebugMessages;
import it.zerono.mods.zerocore.lib.block.INeighborChangeListener;
import it.zerono.mods.zerocore.lib.data.component.IComponentProvider;
import it.zerono.mods.zerocore.lib.data.component.ItemStackListComponent;
import it.zerono.mods.zerocore.lib.data.nbt.IConditionallySyncableEntity;
import it.zerono.mods.zerocore.lib.data.nbt.ISyncableEntity;
import it.zerono.mods.zerocore.lib.data.stack.IStackHolder;
import it.zerono.mods.zerocore.lib.item.ItemHelper;
import it.zerono.mods.zerocore.lib.item.inventory.ItemStackHolder;
import it.zerono.mods.zerocore.lib.recipe.ingredient.IRecipeIngredientSource;
import it.zerono.mods.zerocore.lib.recipe.ingredient.RecipeIngredientSourceWrapper;
import it.zerono.mods.zerocore.lib.text.TextHelper;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.fml.LogicalSide;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidizerSolidInjectorEntity
extends AbstractFluidizerEntity
implements MenuProvider,
INeighborChangeListener,
IConditionallySyncableEntity,
IComponentProvider<ItemStackListComponent> {
    private static final ResourceLocation SYNC_DATA_ID = ExtremeReactors.ROOT_LOCATION.buildWithSuffix("solidinjector");
    private final ItemStackHolder _solidItems = (ItemStackHolder)((ItemStackHolder)new ItemStackHolder(1, ($, stack) -> this.isValidIngredient((ItemStack)stack)).setOnLoadListener(this::onItemsChanged)).setOnContentsChangedListener(this::onItemsChanged);
    private boolean _shouldSync;

    public FluidizerSolidInjectorEntity(BlockPos position, BlockState blockState) {
        super(Content.TileEntityTypes.FLUIDIZER_SOLIDINJECTOR.get(), position, blockState);
    }

    public IRecipeIngredientSource<ItemStack> asRecipeSource() {
        return RecipeIngredientSourceWrapper.wrap((IItemHandler)this._solidItems, (int)0);
    }

    public IItemHandlerModifiable getItemHandler() {
        return this._solidItems;
    }

    public ItemStack getStack() {
        return this._solidItems.getStackAt(0);
    }

    public boolean isValidIngredient(ItemStack stack) {
        return (Boolean)this.evalOnController(c -> c.isValidIngredient(stack), false);
    }

    public static void itemTooltipBuilder(ItemStack stack, Item.TooltipContext context, Consumer<@NotNull Component> appender, TooltipFlag flag) {
        ItemStackListComponent component = (ItemStackListComponent)stack.get(ItemStackListComponent.getComponentType());
        if (null != component) {
            MutableComponent text = component.isEmpty(0) ? BaseHelper.emptyValue() : TextHelper.translatable((String)"gui.bigreactors.fluidizer.solidinjector.component.content", (Object[])new Object[]{ItemHelper.getItemName((ItemStack)((ItemStack)component.getStack(0))), component.getAmount(0)});
            appender.accept((Component)text.setStyle(CommonConstants.STYLE_TOOLTIP_VALUE));
        }
    }

    @Override
    protected int getUpdatedModelVariantIndex() {
        return this.isMachineAssembled() && null != this.getNeighborCapability() ? 1 : 0;
    }

    public void onNeighborBlockChanged(BlockState state, BlockPos neighborPosition, boolean isMoving) {
        this.requestClientRenderUpdate();
    }

    public void onNeighborTileChanged(BlockState state, BlockPos neighborPosition) {
        this.requestClientRenderUpdate();
    }

    public void syncDataFrom(CompoundTag data, HolderLookup.Provider registries, ISyncableEntity.SyncReason syncReason) {
        super.syncDataFrom(data, registries, syncReason);
        this.syncChildDataEntityFrom((ISyncableEntity)this._solidItems, "inv", data, registries, syncReason);
        if (syncReason.isFullSync()) {
            this._shouldSync = true;
        }
    }

    public CompoundTag syncDataTo(CompoundTag data, HolderLookup.Provider registries, ISyncableEntity.SyncReason syncReason) {
        super.syncDataTo(data, registries, syncReason);
        this.syncChildDataEntityTo((ISyncableEntity)this._solidItems, "inv", data, registries, syncReason);
        return data;
    }

    public ResourceLocation getSyncableEntityId() {
        return SYNC_DATA_ID;
    }

    public boolean shouldSyncEntity() {
        boolean result = this._shouldSync;
        this._shouldSync = false;
        return result;
    }

    public ItemStackListComponent createDataComponent() {
        return this._solidItems.createDataComponent();
    }

    public void mergeComponent(ItemStackListComponent component) {
        this._solidItems.mergeComponent(component);
    }

    @Override
    public void getDebugMessages(LogicalSide side, IDebugMessages messages) {
        super.getDebugMessages(side, messages);
        messages.add((Object)this._solidItems, DebuggableHelper::getDebugMessagesFor, "Items");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int windowId, Inventory inventory, Player player) {
        return new FluidizerSolidInjectorContainer(windowId, inventory, this);
    }

    public Component getDisplayName() {
        return super.getPartDisplayName();
    }

    public boolean canOpenGui(Level world, BlockPos position, BlockState state) {
        return true;
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput input) {
        ItemStackListComponent component = (ItemStackListComponent)input.get(ItemStackListComponent.getComponentType());
        if (null != component) {
            this.mergeComponent(component);
        }
    }

    protected void collectImplicitComponents(DataComponentMap.Builder collector) {
        collector.set(ItemStackListComponent.getComponentType(), (Object)this.createDataComponent());
    }

    public ItemStack asStorableStack() {
        ItemStack stack = new ItemStack((ItemLike)this.getBlockType());
        stack.set(ItemStackListComponent.getComponentType(), (Object)this.createDataComponent());
        return stack;
    }

    @Nullable
    private IItemHandler getNeighborCapability() {
        return CodeHelper.optionalMap((Optional)this.getPartWorld(), (Optional)this.getOutwardDirection(), (level, direction) -> (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, this.getWorldPosition().relative(direction), (Object)direction.getOpposite())).orElse(null);
    }

    private void onItemsChanged() {
        this.onItemsChanged(IStackHolder.ChangeType.Replaced, 0);
    }

    private void onItemsChanged(IStackHolder.ChangeType changeType, int slot) {
        this.setChanged();
        this.onIngredientsChanged(changeType);
        this._shouldSync = true;
    }
}

