/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.datagen.recipes;

import com.github.jarva.arsadditions.ArsAdditions;
import com.github.jarva.arsadditions.common.recipe.LocateStructureRecipe;
import com.github.jarva.arsadditions.common.util.codec.ResourceOrTag;
import com.github.jarva.arsadditions.datagen.tags.StructureTagDatagen;
import com.google.gson.JsonElement;
import com.hollingsworth.arsnouveau.common.datagen.SimpleDataProvider;
import com.hollingsworth.arsnouveau.common.datagen.StructureTagProvider;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.levelgen.structure.Structure;

public class LocateStructureProvider
extends SimpleDataProvider {
    public List<LocateStructureRecipe> recipes = new ArrayList<LocateStructureRecipe>();

    public LocateStructureProvider(DataGenerator generatorIn) {
        super(generatorIn);
    }

    public void collectJsons(CachedOutput pOutput) {
        this.addEntries();
        for (LocateStructureRecipe recipe : this.recipes) {
            Path path = LocateStructureProvider.getRecipePath(this.output, recipe.getId().getPath());
            LocateStructureRecipe.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)recipe).result().ifPresent(json -> this.saveStable(pOutput, (JsonElement)json, path));
        }
    }

    protected void addEntries() {
        this.addEntry("pillager_outpost", StructureTagDatagen.PILLAGER_OUTPOST, ResourceOrTag.item(Items.EMERALD));
        this.addEntry("end_city", StructureTagDatagen.END_CITY, ResourceOrTag.item(Items.PURPUR_BLOCK));
        this.addEntry("jungle_temple", StructureTagDatagen.JUNGLE_TEMPLE, ResourceOrTag.item(Items.MOSSY_COBBLESTONE));
        this.addEntry("wilden_den", (TagKey<Structure>)StructureTagProvider.WILDEN_DEN, ResourceOrTag.item((Item)ItemsRegistry.SOURCE_GEM.get()));
        this.addEntry("monument", StructureTagDatagen.MONUMENT, ResourceOrTag.tag(ItemTags.FISHES));
        this.addEntry("fortress", StructureTagDatagen.NETHER_FORTRESS, ResourceOrTag.item(Items.NETHER_BRICK));
        this.addEntry("ancient_city", StructureTagDatagen.ANCIENT_CITY, ResourceOrTag.item(Items.DEEPSLATE_BRICKS));
        this.addEntry("igloo", StructureTagDatagen.IGLOO, ResourceOrTag.item(Items.ICE));
        this.addEntry("bastion", StructureTagDatagen.BASTION, ResourceOrTag.item(Items.POLISHED_BLACKSTONE_BRICKS));
        this.addEntry("desert_temple", StructureTagDatagen.DESERT_TEMPLE, ResourceOrTag.item(Items.SANDSTONE));
        this.addEntry("trail_ruins", StructureTagDatagen.TRAIL_RUINS, ResourceOrTag.tag(ItemTags.TERRACOTTA));
        this.addEntry("arcane_library", (ResourceKey<Structure>)ResourceKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)ArsAdditions.prefix("arcane_library")), ResourceOrTag.item((Item)ItemsRegistry.APPRENTICE_SPELLBOOK.get()));
        this.addEntry("stronghold", StructureTagDatagen.STRONGHOLD, ResourceOrTag.item(Items.ENDER_EYE), ResourceOrTag.item(Items.ENDER_EYE), ResourceOrTag.item(Items.ENDER_EYE), ResourceOrTag.item(Items.ENDER_EYE), ResourceOrTag.item(Items.ENDER_EYE), ResourceOrTag.item(Items.ENDER_EYE), ResourceOrTag.item(Items.ENDER_EYE), ResourceOrTag.item(Items.ENDER_EYE), ResourceOrTag.item(Items.ENDER_EYE), ResourceOrTag.item(Items.ENDER_EYE), ResourceOrTag.item(Items.ENDER_EYE), ResourceOrTag.item(Items.ENDER_EYE));
        this.addEntry("trial_chamber", StructureTagDatagen.TRIAL_CHAMBERS, ResourceOrTag.item(Items.OMINOUS_BOTTLE));
        this.addEntry("woodland_mansion", StructureTagDatagen.WOODLAND_MANSION, ResourceOrTag.item(Items.BROWN_MUSHROOM), ResourceOrTag.item(Items.RED_MUSHROOM));
    }

    private void addEntry(String id, ResourceKey<Structure> structureId, ResourceOrTag<Item> ... augments) {
        this.addEntry(id, ResourceOrTag.key(structureId), augments);
    }

    private void addEntry(String id, TagKey<Structure> structureId, ResourceOrTag<Item> ... augments) {
        this.addEntry(id, ResourceOrTag.tag(structureId), augments);
    }

    private void addEntry(String id, ResourceOrTag<Structure> structure, ResourceOrTag<Item> ... augments) {
        this.recipes.add(new LocateStructureRecipe(ArsAdditions.prefix(id), List.of(augments), structure, 50, true));
    }

    protected static Path getRecipePath(Path path, String id) {
        return path.resolve("data/ars_additions/recipe/locate_structure/" + id + ".json");
    }

    public String getName() {
        return "Locate Structure Datagen";
    }
}

