/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.common.util;

import com.github.jarva.arsadditions.common.block.tile.SourceSpawnerTile;
import com.github.jarva.arsadditions.common.recipe.SourceSpawnerRecipe;
import com.github.jarva.arsadditions.common.util.AddonSourceUtil;
import com.github.jarva.arsadditions.common.util.codec.TagModifier;
import com.github.jarva.arsadditions.datagen.tags.EntityTypeTagDatagen;
import com.github.jarva.arsadditions.setup.registry.AddonBlockRegistry;
import com.github.jarva.arsadditions.setup.registry.ModifyTagRegistry;
import com.github.jarva.arsadditions.setup.registry.recipes.SourceSpawnerRegistry;
import com.hollingsworth.arsnouveau.common.block.tile.MobJarTile;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class SourceSpawner
extends BaseSpawner {
    private final BlockEntity blockEntity;
    public boolean disabled = false;
    public WeightedRandomList<WeightedEntry.Wrapper<SpawnData>> spawnPotentials = WeightedRandomList.create();
    public HashMap<EntityType<?>, SourceSpawnerRecipe> recipes = new HashMap();
    public short spawnDelay = (short)20;
    public short minSpawnDelay = (short)200;
    public short maxSpawnDelay = (short)800;
    public short spawnCount = (short)4;
    public short maxNearbyEntities = (short)6;
    public short requiredPlayerRange = (short)16;
    public short spawnRange = (short)4;
    private static final ModifyTagRegistry.AppendTag APPEND_SOURCE_SPAWNER_TAG = new ModifyTagRegistry.AppendTag(Map.of("Tags", StringTag.valueOf((String)"ars_additions:source_spawner")));

    public SourceSpawner(SourceSpawnerTile sourceSpawnerTile) {
        this.blockEntity = sourceSpawnerTile;
    }

    public void load(@Nullable Level level, BlockPos pos, CompoundTag tag) {
        this.spawnDelay = tag.getShort("Delay");
        if (tag.contains("MinSpawnDelay", 99)) {
            this.minSpawnDelay = tag.getShort("MinSpawnDelay");
            this.maxSpawnDelay = tag.getShort("MaxSpawnDelay");
            this.spawnCount = tag.getShort("SpawnCount");
        }
        if (tag.contains("MaxNearbyEntities", 99)) {
            this.maxNearbyEntities = tag.getShort("MaxNearbyEntities");
            this.requiredPlayerRange = tag.getShort("RequiredPlayerRange");
        }
        if (tag.contains("SpawnRange", 99)) {
            this.spawnRange = tag.getShort("SpawnRange");
        }
        this.disabled = tag.getBoolean("Disabled");
    }

    public CompoundTag save(CompoundTag tag) {
        tag.putShort("Delay", this.spawnDelay);
        tag.putShort("MinSpawnDelay", this.minSpawnDelay);
        tag.putShort("MaxSpawnDelay", this.maxSpawnDelay);
        tag.putShort("SpawnCount", this.spawnCount);
        tag.putShort("MaxNearbyEntities", this.maxNearbyEntities);
        tag.putShort("RequiredPlayerRange", this.requiredPlayerRange);
        tag.putShort("SpawnRange", this.spawnRange);
        tag.putBoolean("Disabled", this.disabled);
        return tag;
    }

    public void broadcastEvent(Level level, BlockPos pos, int eventId) {
        level.blockEvent(pos, (Block)AddonBlockRegistry.SOURCE_SPAWNER.get(), eventId, 0);
    }

    private void delay(Level level, BlockPos pos) {
        RandomSource randomSource = level.getRandom();
        this.spawnDelay = this.maxSpawnDelay <= this.minSpawnDelay ? this.minSpawnDelay : (short)(this.minSpawnDelay + randomSource.nextInt(this.maxSpawnDelay - this.minSpawnDelay));
    }

    private SimpleWeightedRandomList<SpawnData> getEntities(ServerLevel level, BlockPos pos) {
        SimpleWeightedRandomList.Builder builder = SimpleWeightedRandomList.builder();
        for (BlockPos b : BlockPos.withinManhattan((BlockPos)pos, (int)10, (int)10, (int)10)) {
            LivingEntity livingEntity;
            EntityType type;
            MobJarTile mobJarTile;
            BlockEntity blockEntity = level.getBlockEntity(b);
            if (!(blockEntity instanceof MobJarTile) || !((blockEntity = (mobJarTile = (MobJarTile)blockEntity).getEntity()) instanceof LivingEntity) || (type = (livingEntity = (LivingEntity)blockEntity).getType()).is(EntityTypeTagDatagen.SOURCE_SPAWNER_DENYLIST)) continue;
            CompoundTag entityTag = new CompoundTag();
            entityTag.putString("id", BuiltInRegistries.ENTITY_TYPE.getKey((Object)type).toString());
            this.getRecipe((Entity)livingEntity).ifPresent(recipe -> {
                this.recipes.put((EntityType<?>)type, (SourceSpawnerRecipe)recipe);
                recipe.tag_modifiers().ifPresent(modifiers -> {
                    livingEntity.saveAsPassenger(entityTag);
                    for (TagModifier modifier : modifiers) {
                        modifier.modify(entityTag);
                    }
                });
            });
            entityTag.remove("UUID");
            APPEND_SOURCE_SPAWNER_TAG.modify(entityTag);
            builder.add((Object)new SpawnData(entityTag, Optional.empty(), Optional.empty()), 1);
        }
        return builder.build();
    }

    public void removeEntry(WeightedEntry.Wrapper<SpawnData> entry) {
        ArrayList potentials = new ArrayList(this.spawnPotentials.unwrap());
        potentials.remove(entry);
        this.spawnPotentials = WeightedRandomList.create(potentials);
    }

    public Optional<SourceSpawnerRecipe> getRecipe(Entity entity) {
        return SourceSpawnerRegistry.INSTANCE.getRecipes().stream().filter(r -> ((SourceSpawnerRecipe)r.value()).isMatch(entity.getType())).findFirst().map(RecipeHolder::value);
    }

    public int calculateSource(Entity entity) {
        EntityType type = entity.getType();
        SourceSpawnerRecipe recipe = this.recipes.get(type);
        if (recipe != null && recipe.source().isPresent()) {
            return recipe.source().get();
        }
        int source = 200;
        if (type.is(EntityTypeTagDatagen.BOSSES)) {
            source += 10000;
        }
        if (type.getCategory().isPersistent()) {
            source += 1000;
        }
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            source += (int)(mob.getMaxHealth() * 50.0f);
        }
        return source;
    }

    public void serverTick(ServerLevel level, BlockPos pos) {
        if (!this.isNearPlayer((Level)level, pos)) {
            return;
        }
        if (this.spawnDelay == -1) {
            this.delay((Level)level, pos);
            return;
        }
        if (this.spawnDelay > 0) {
            this.spawnDelay = (short)(this.spawnDelay - 1);
            return;
        }
        if (this.disabled) {
            return;
        }
        this.spawnPotentials = this.getEntities(level, pos);
        if (this.spawnPotentials.isEmpty()) {
            this.delay((Level)level, pos);
            return;
        }
        RandomSource randomSource = level.getRandom();
        int count = this.spawnCount;
        while (count > 0) {
            double z;
            double y;
            double x;
            int total = this.spawnPotentials.unwrap().size();
            if (total == 0) {
                this.delay((Level)level, pos);
                return;
            }
            WeightedEntry.Wrapper wrappedSpawnData = this.spawnPotentials.getRandom(randomSource).orElse(null);
            if (wrappedSpawnData == null) {
                this.delay((Level)level, pos);
                return;
            }
            SpawnData spawnData = (SpawnData)wrappedSpawnData.data();
            CompoundTag entityTag = spawnData.getEntityToSpawn();
            Optional entityTypeOptional = EntityType.by((CompoundTag)entityTag);
            if (entityTypeOptional.isEmpty()) {
                this.removeEntry((WeightedEntry.Wrapper<SpawnData>)wrappedSpawnData);
                continue;
            }
            EntityType entityType = (EntityType)entityTypeOptional.get();
            if (!level.noCollision(entityType.getSpawnAABB(x = (double)pos.getX() + (randomSource.nextDouble() - randomSource.nextDouble()) * (double)this.spawnRange + 0.5, y = (double)(pos.getY() + randomSource.nextInt(3) - 1), z = (double)pos.getZ() + (randomSource.nextDouble() - randomSource.nextDouble()) * (double)this.spawnRange + 0.5))) continue;
            if (!entityType.getCategory().isFriendly() && level.getDifficulty() == Difficulty.PEACEFUL) {
                this.removeEntry((WeightedEntry.Wrapper<SpawnData>)wrappedSpawnData);
                continue;
            }
            Entity entity = EntityType.loadEntityRecursive((CompoundTag)entityTag, (Level)level, arg -> {
                arg.moveTo(x, y, z, arg.getYRot(), arg.getXRot());
                return arg;
            });
            if (entity == null) {
                this.removeEntry((WeightedEntry.Wrapper<SpawnData>)wrappedSpawnData);
                continue;
            }
            int nearby = level.getEntitiesOfClass(entity.getClass(), new AABB((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (double)(pos.getX() + 1), (double)(pos.getY() + 1), (double)(pos.getZ() + 1)).inflate((double)this.spawnRange)).size();
            if (nearby >= this.maxNearbyEntities) {
                this.removeEntry((WeightedEntry.Wrapper<SpawnData>)wrappedSpawnData);
                continue;
            }
            entity.moveTo(entity.getX(), entity.getY(), entity.getZ(), randomSource.nextFloat() * 360.0f, 0.0f);
            if (!level.tryAddFreshEntityWithPassengers(entity)) {
                this.removeEntry((WeightedEntry.Wrapper<SpawnData>)wrappedSpawnData);
                continue;
            }
            int neededSource = this.calculateSource(entity);
            boolean tookSource = AddonSourceUtil.takeSource(pos, (Level)level, 5, neededSource);
            if (!tookSource) {
                entity.remove(Entity.RemovalReason.DISCARDED);
                this.removeEntry((WeightedEntry.Wrapper<SpawnData>)wrappedSpawnData);
                continue;
            }
            level.levelEvent(2004, pos, 0);
            level.gameEvent(entity, (Holder)GameEvent.ENTITY_PLACE, pos);
            if (entity instanceof Mob) {
                Mob mob = (Mob)entity;
                mob.spawnAnim();
            }
            --count;
        }
        if (count < this.spawnCount) {
            this.delay((Level)level, pos);
        }
    }

    private boolean isNearPlayer(Level level, BlockPos pos) {
        return level.hasNearbyAlivePlayer((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, (double)this.requiredPlayerRange);
    }

    public void clientTick(Level level, BlockPos pos) {
        if (this.isNearPlayer(level, pos) && !this.disabled) {
            RandomSource randomSource = level.getRandom();
            double x = (double)pos.getX() + randomSource.nextDouble();
            double y = (double)pos.getY() + randomSource.nextDouble();
            double z = (double)pos.getZ() + randomSource.nextDouble();
            level.addParticle((ParticleOptions)ParticleTypes.SMOKE, x, y, z, 0.0, 0.0, 0.0);
            level.addParticle((ParticleOptions)ParticleTypes.FLAME, x, y, z, 0.0, 0.0, 0.0);
            if (this.spawnDelay > 0) {
                this.spawnDelay = (short)(this.spawnDelay - 1);
            }
        }
    }

    @Nullable
    public Either<BlockEntity, Entity> getOwner() {
        return Either.left((Object)this.blockEntity);
    }
}

