/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.common.recipe;

import com.github.jarva.arsadditions.common.util.LangUtil;
import com.github.jarva.arsadditions.common.util.codec.ResourceOrTag;
import com.github.jarva.arsadditions.server.util.LocateUtil;
import com.github.jarva.arsadditions.setup.registry.AddonRecipeRegistry;
import com.hollingsworth.arsnouveau.common.crafting.recipes.CheatSerializer;
import com.hollingsworth.arsnouveau.common.crafting.recipes.EnchantingApparatusRecipe;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.Structure;

public class LocateStructureRecipe
implements Recipe<RecipeInput> {
    private final NonNullList<Ingredient> ingredients;
    private final ResourceLocation id;
    private final List<ResourceOrTag<Item>> augments;
    private final ResourceOrTag<Structure> structure;
    private final boolean skipKnownStructures;
    private final int radius;

    public LocateStructureRecipe(ResourceLocation id, List<ResourceOrTag<Item>> augments, ResourceOrTag<Structure> structure, int radius, boolean skipKnownStructures) {
        this.id = id;
        this.augments = augments;
        this.structure = structure;
        this.radius = radius;
        this.skipKnownStructures = skipKnownStructures;
        ArrayList ingredientList = new ArrayList();
        augments.forEach(either -> either.tag().map(Ingredient::of).or(() -> either.key().map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ITEM).get(arg_0)).map(xva$0 -> Ingredient.of((ItemLike[])new ItemLike[]{xva$0}))).ifPresent(ingredientList::add));
        this.ingredients = NonNullList.of((Object)Ingredient.EMPTY, (Object[])ingredientList.toArray(new Ingredient[0]));
    }

    public boolean matches(List<ItemStack> input) {
        return EnchantingApparatusRecipe.doItemsMatch(input, this.ingredients);
    }

    public boolean matches(RecipeInput recipeInput, Level level) {
        return false;
    }

    public ItemStack assemble(RecipeInput recipeInput, HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int i, int i1) {
        return false;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return null;
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.ingredients;
    }

    private List<ResourceOrTag<Item>> getAugments() {
        return this.augments;
    }

    public ResourceOrTag<Structure> getStructure() {
        return this.structure;
    }

    public Component getName() {
        return this.structure.map(key -> key.location().getPath(), tag -> tag.location().getPath()).map(LangUtil::toTitleCase).orElse((Component)Component.empty());
    }

    public HolderSet<Structure> getStructureHolder(ServerLevel level) {
        return this.structure.tag().map(tag -> LocateUtil.holderFromTag(level, (TagKey<Structure>)tag)).or(() -> this.structure.key().map(value -> LocateUtil.holderFromResource(level, (ResourceKey<Structure>)value))).orElse(null);
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public int getRadius() {
        return this.radius;
    }

    public boolean getSkipExisting() {
        return this.skipKnownStructures;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)AddonRecipeRegistry.LOCATE_STRUCTURE_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)AddonRecipeRegistry.LOCATE_STRUCTURE_TYPE.get();
    }

    public boolean isSpecial() {
        return true;
    }

    public static class Serializer
    implements RecipeSerializer<LocateStructureRecipe> {
        public static final MapCodec<LocateStructureRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("id").forGetter(LocateStructureRecipe::getId), (App)ResourceOrTag.ITEM_CODEC.codec().listOf().fieldOf("augments").forGetter(LocateStructureRecipe::getAugments), (App)ResourceOrTag.STRUCTURE_CODEC.fieldOf("structure").forGetter(LocateStructureRecipe::getStructure), (App)Codec.INT.optionalFieldOf("radius", (Object)50).forGetter(LocateStructureRecipe::getRadius), (App)Codec.BOOL.optionalFieldOf("skip_known_structures", (Object)true).forGetter(LocateStructureRecipe::getSkipExisting)).apply((Applicative)instance, LocateStructureRecipe::new));

        public MapCodec<LocateStructureRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, LocateStructureRecipe> streamCodec() {
            return CheatSerializer.create(CODEC);
        }
    }
}

